/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.ShortProcedure;
import cern.colt.list.AbstractShortList;
import cern.jet.math.Arithmetic;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.Date;

public class ShortArrayList
extends AbstractShortList {
    protected short[] elements;

    public ShortArrayList() {
        this(10);
    }

    public ShortArrayList(short[] sArray) {
        this.elements(sArray);
    }

    public ShortArrayList(int n) {
        this(new short[n]);
        this.setSizeRaw(0);
    }

    public void add(short s2) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = s2;
    }

    public void beforeInsert(int n, short s2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = s2;
        ++this.size;
    }

    public int binarySearchFromTo(short s2, int n, int n2) {
        return Sorting.binarySearchFromTo(this.elements, s2, n, n2);
    }

    public Object clone() {
        ShortArrayList shortArrayList = new ShortArrayList((short[])this.elements.clone());
        shortArrayList.setSizeRaw(this.size);
        return shortArrayList;
    }

    public ShortArrayList copy() {
        return (ShortArrayList)this.clone();
    }

    protected void countSortFromTo(int n, int n2, short s2, short s3) {
        if (this.size == 0) {
            return;
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        int n3 = s3 - s2 + 1;
        int[] nArray = new int[n3];
        short[] sArray = this.elements;
        int n4 = n;
        while (n4 <= n2) {
            int n5 = sArray[n4++] - s2;
            nArray[n5] = nArray[n5] + 1;
        }
        n4 = n;
        short s4 = s2;
        int n6 = 0;
        while (n6 < n3) {
            int n7 = nArray[n6];
            if (n7 > 0) {
                if (n7 == 1) {
                    sArray[n4++] = s4;
                } else {
                    int n8 = n4 + n7 - 1;
                    this.fillFromToWith(n4, n8, s4);
                    n4 = n8 + 1;
                }
            }
            ++n6;
            s4 = (short)(s4 + 1);
        }
    }

    public short[] elements() {
        return this.elements;
    }

    public AbstractShortList elements(short[] sArray) {
        this.elements = sArray;
        this.size = sArray.length;
        return this;
    }

    public void ensureCapacity(int n) {
        this.elements = Arrays.ensureCapacity(this.elements, n);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ShortArrayList)) {
            return super.equals(object);
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        ShortArrayList shortArrayList = (ShortArrayList)object;
        if (this.size() != shortArrayList.size()) {
            return false;
        }
        short[] sArray = this.elements();
        short[] sArray2 = shortArrayList.elements();
        int n = this.size();
        while (--n >= 0) {
            if (sArray[n] == sArray2[n]) continue;
            return false;
        }
        return true;
    }

    public boolean forEach(ShortProcedure shortProcedure) {
        short[] sArray = this.elements;
        int n = this.size;
        int n2 = 0;
        while (n2 < n) {
            if (shortProcedure.apply(sArray[n2++])) continue;
            return false;
        }
        return true;
    }

    public short get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.elements[n];
    }

    public short getQuick(int n) {
        return this.elements[n];
    }

    public int indexOfFromTo(short s2, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = this.elements;
        for (int i = n; i <= n2; ++i) {
            if (s2 != sArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOfFromTo(short s2, int n, int n2) {
        if (this.size == 0) {
            return -1;
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = this.elements;
        for (int i = n2; i >= n; --i) {
            if (s2 != sArray[i]) continue;
            return i;
        }
        return -1;
    }

    public AbstractShortList partFromTo(int n, int n2) {
        if (this.size == 0) {
            return new ShortArrayList(0);
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        short[] sArray = new short[n2 - n + 1];
        System.arraycopy(this.elements, n, sArray, 0, n2 - n + 1);
        return new ShortArrayList(sArray);
    }

    public boolean removeAll(AbstractShortList abstractShortList) {
        double d;
        if (!(abstractShortList instanceof ShortArrayList)) {
            return super.removeAll(abstractShortList);
        }
        if (abstractShortList.size() == 0) {
            return false;
        }
        int n = abstractShortList.size() - 1;
        int n2 = 0;
        short[] sArray = this.elements;
        int n3 = this.size();
        double d2 = abstractShortList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            ShortArrayList shortArrayList = (ShortArrayList)abstractShortList.clone();
            shortArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (shortArrayList.binarySearchFromTo(sArray[i], 0, n) >= 0) continue;
                sArray[n2++] = sArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractShortList.indexOfFromTo(sArray[i], 0, n) >= 0) continue;
                sArray[n2++] = sArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractShortList abstractShortList, int n3) {
        if (!(abstractShortList instanceof ShortArrayList)) {
            super.replaceFromToWithFrom(n, n2, abstractShortList, n3);
            return;
        }
        int n4 = n2 - n + 1;
        if (n4 > 0) {
            ShortArrayList.checkRangeFromTo(n, n2, this.size());
            ShortArrayList.checkRangeFromTo(n3, n3 + n4 - 1, abstractShortList.size());
            System.arraycopy(((ShortArrayList)abstractShortList).elements, n3, this.elements, n, n4);
        }
    }

    public boolean retainAll(AbstractShortList abstractShortList) {
        double d;
        if (!(abstractShortList instanceof ShortArrayList)) {
            return super.retainAll(abstractShortList);
        }
        int n = abstractShortList.size() - 1;
        int n2 = 0;
        short[] sArray = this.elements;
        int n3 = this.size();
        double d2 = abstractShortList.size();
        if ((d2 + (d = (double)n3)) * Arithmetic.log2(d2) < d * d2) {
            ShortArrayList shortArrayList = (ShortArrayList)abstractShortList.clone();
            shortArrayList.quickSort();
            for (int i = 0; i < n3; ++i) {
                if (shortArrayList.binarySearchFromTo(sArray[i], 0, n) < 0) continue;
                sArray[n2++] = sArray[i];
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (abstractShortList.indexOfFromTo(sArray[i], 0, n) < 0) continue;
                sArray[n2++] = sArray[i];
            }
        }
        boolean bl = n2 != n3;
        this.setSize(n2);
        return bl;
    }

    public void reverse() {
        int n = this.size / 2;
        int n2 = this.size - 1;
        short[] sArray = this.elements;
        int n3 = 0;
        while (n3 < n) {
            short s2 = sArray[n3];
            sArray[n3++] = sArray[n2];
            sArray[n2--] = s2;
        }
    }

    public void set(int n, short s2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.elements[n] = s2;
    }

    public void setQuick(int n, short s2) {
        this.elements[n] = s2;
    }

    public void shuffleFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        Uniform uniform = new Uniform(new DRand(new Date()));
        short[] sArray = this.elements;
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            short s2 = sArray[n3];
            sArray[n3] = sArray[i];
            sArray[i] = s2;
        }
    }

    public void sortFromTo(int n, int n2) {
        if (this.size == 0) {
            return;
        }
        ShortArrayList.checkRangeFromTo(n, n2, this.size);
        short s2 = this.elements[n];
        short s3 = this.elements[n];
        short[] sArray = this.elements;
        int n3 = n + 1;
        while (n3 <= n2) {
            short s4;
            if ((s4 = sArray[n3++]) > s3) {
                s3 = s4;
                continue;
            }
            if (s4 >= s2) continue;
            s2 = s4;
        }
        double d = (double)n2 - (double)n + 1.0;
        double d2 = d * Math.log(d) / 0.6931471805599453;
        double d3 = (double)s3 - (double)s2 + 1.0;
        double d4 = Math.max(d3, d);
        if (d3 < 10000.0 && d4 < d2) {
            this.countSortFromTo(n, n2, s2, s3);
        } else {
            this.quickSortFromTo(n, n2);
        }
    }

    public void trimToSize() {
        this.elements = Arrays.trimToCapacity(this.elements, this.size());
    }
}

