/*
 * Decompiled with CFR 0.152.
 */
package cern.colt.list;

import cern.colt.Arrays;
import cern.colt.Sorting;
import cern.colt.function.ShortComparator;
import cern.colt.function.ShortProcedure;
import cern.colt.list.AbstractList;
import cern.colt.list.ShortArrayList;
import cern.jet.random.Uniform;
import cern.jet.random.engine.DRand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;

public abstract class AbstractShortList
extends AbstractList {
    protected int size;

    protected AbstractShortList() {
    }

    public void add(short s2) {
        this.beforeInsert(this.size, s2);
    }

    public void addAllOfFromTo(AbstractShortList abstractShortList, int n, int n2) {
        this.beforeInsertAllOfFromTo(this.size, abstractShortList, n, n2);
    }

    public void beforeInsert(int n, short s2) {
        this.beforeInsertDummies(n, 1);
        this.set(n, s2);
    }

    public void beforeInsertAllOfFromTo(int n, AbstractShortList abstractShortList, int n2, int n3) {
        int n4 = n3 - n2 + 1;
        this.beforeInsertDummies(n, n4);
        this.replaceFromToWithFrom(n, n + n4 - 1, abstractShortList, n2);
    }

    protected void beforeInsertDummies(int n, int n2) {
        if (n > this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        if (n2 > 0) {
            this.ensureCapacity(this.size + n2);
            this.setSizeRaw(this.size + n2);
            this.replaceFromToWithFrom(n + n2, this.size - 1, this, n);
        }
    }

    public int binarySearch(short s2) {
        return this.binarySearchFromTo(s2, 0, this.size - 1);
    }

    public int binarySearchFromTo(short s2, int n, int n2) {
        int n3 = n;
        int n4 = n2;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            short s3 = this.get(n5);
            if (s3 < s2) {
                n3 = n5 + 1;
                continue;
            }
            if (s3 > s2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public Object clone() {
        return this.partFromTo(0, this.size - 1);
    }

    public boolean contains(short s2) {
        return this.indexOfFromTo(s2, 0, this.size - 1) >= 0;
    }

    public void delete(short s2) {
        int n = this.indexOfFromTo(s2, 0, this.size - 1);
        if (n >= 0) {
            this.remove(n);
        }
    }

    public short[] elements() {
        short[] sArray = new short[this.size];
        int n = this.size;
        while (--n >= 0) {
            sArray[n] = this.getQuick(n);
        }
        return sArray;
    }

    public AbstractShortList elements(short[] sArray) {
        this.clear();
        this.addAllOfFromTo(new ShortArrayList(sArray), 0, sArray.length - 1);
        return this;
    }

    public abstract void ensureCapacity(int var1);

    public boolean equals(Object object) {
        if (!(object instanceof AbstractShortList)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        AbstractShortList abstractShortList = (AbstractShortList)object;
        if (this.size() != abstractShortList.size()) {
            return false;
        }
        int n = this.size();
        while (--n >= 0) {
            if (this.getQuick(n) == abstractShortList.getQuick(n)) continue;
            return false;
        }
        return true;
    }

    public void fillFromToWith(int n, int n2, short s2) {
        AbstractShortList.checkRangeFromTo(n, n2, this.size);
        int n3 = n;
        while (n3 <= n2) {
            this.setQuick(n3++, s2);
        }
    }

    public boolean forEach(ShortProcedure shortProcedure) {
        int n = 0;
        while (n < this.size) {
            if (shortProcedure.apply(this.get(n++))) continue;
            return false;
        }
        return true;
    }

    public short get(int n) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        return this.getQuick(n);
    }

    protected abstract short getQuick(int var1);

    public int indexOf(short s2) {
        return this.indexOfFromTo(s2, 0, this.size - 1);
    }

    public int indexOfFromTo(short s2, int n, int n2) {
        AbstractShortList.checkRangeFromTo(n, n2, this.size);
        for (int i = n; i <= n2; ++i) {
            if (s2 != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short s2) {
        return this.lastIndexOfFromTo(s2, 0, this.size - 1);
    }

    public int lastIndexOfFromTo(short s2, int n, int n2) {
        AbstractShortList.checkRangeFromTo(n, n2, this.size());
        for (int i = n2; i >= n; --i) {
            if (s2 != this.getQuick(i)) continue;
            return i;
        }
        return -1;
    }

    public void mergeSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractShortList.checkRangeFromTo(n, n2, n3);
        short[] sArray = this.elements();
        Sorting.mergeSort(sArray, n, n2 + 1);
        this.elements(sArray);
        this.setSizeRaw(n3);
    }

    public void mergeSortFromTo(int n, int n2, ShortComparator shortComparator) {
        int n3 = this.size();
        AbstractShortList.checkRangeFromTo(n, n2, n3);
        short[] sArray = this.elements();
        Sorting.mergeSort(sArray, n, n2 + 1, shortComparator);
        this.elements(sArray);
        this.setSizeRaw(n3);
    }

    public AbstractShortList partFromTo(int n, int n2) {
        AbstractShortList.checkRangeFromTo(n, n2, this.size);
        int n3 = n2 - n + 1;
        ShortArrayList shortArrayList = new ShortArrayList(n3);
        shortArrayList.addAllOfFromTo(this, n, n2);
        return shortArrayList;
    }

    public void quickSortFromTo(int n, int n2) {
        int n3 = this.size();
        AbstractShortList.checkRangeFromTo(n, n2, n3);
        short[] sArray = this.elements();
        java.util.Arrays.sort(sArray, n, n2 + 1);
        this.elements(sArray);
        this.setSizeRaw(n3);
    }

    public void quickSortFromTo(int n, int n2, ShortComparator shortComparator) {
        int n3 = this.size();
        AbstractShortList.checkRangeFromTo(n, n2, n3);
        short[] sArray = this.elements();
        Sorting.quickSort(sArray, n, n2 + 1, shortComparator);
        this.elements(sArray);
        this.setSizeRaw(n3);
    }

    public boolean removeAll(AbstractShortList abstractShortList) {
        int n;
        if (abstractShortList.size() == 0) {
            return false;
        }
        int n2 = abstractShortList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractShortList.indexOfFromTo(this.getQuick(n), 0, n2) >= 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void removeFromTo(int n, int n2) {
        int n3;
        AbstractShortList.checkRangeFromTo(n, n2, this.size);
        int n4 = this.size - n2 - 1;
        if (n4 > 0) {
            this.replaceFromToWithFrom(n, n - 1 + n4, this, n2 + 1);
        }
        if ((n3 = n2 - n + 1) > 0) {
            this.setSizeRaw(this.size - n3);
        }
    }

    public void replaceFromToWithFrom(int n, int n2, AbstractShortList abstractShortList, int n3) {
        block4: {
            int n4 = n2 - n + 1;
            if (n4 <= 0) break block4;
            AbstractShortList.checkRangeFromTo(n, n2, this.size());
            AbstractShortList.checkRangeFromTo(n3, n3 + n4 - 1, abstractShortList.size());
            if (n <= n3) {
                while (--n4 >= 0) {
                    this.setQuick(n++, abstractShortList.getQuick(n3++));
                }
            } else {
                int n5 = n3 + n4 - 1;
                while (--n4 >= 0) {
                    this.setQuick(n2--, abstractShortList.getQuick(n5--));
                }
            }
        }
    }

    public void replaceFromToWithFromTo(int n, int n2, AbstractShortList abstractShortList, int n3, int n4) {
        int n5;
        if (n3 > n4) {
            throw new IndexOutOfBoundsException("otherFrom: " + n3 + ", otherTo: " + n4);
        }
        if (this == abstractShortList && n2 - n != n4 - n3) {
            this.replaceFromToWithFromTo(n, n2, this.partFromTo(n3, n4), 0, n4 - n3);
            return;
        }
        int n6 = n5 = n4 - n3 + 1;
        int n7 = n - 1;
        if (n2 >= n) {
            n6 -= n2 - n + 1;
            n7 = n2;
        }
        if (n6 > 0) {
            this.beforeInsertDummies(n7 + 1, n6);
        } else if (n6 < 0) {
            this.removeFromTo(n7 + n6, n7 - 1);
        }
        if (n5 > 0) {
            this.replaceFromToWithFrom(n, n + n5 - 1, abstractShortList, n3);
        }
    }

    public void replaceFromWith(int n, Collection collection) {
        AbstractShortList.checkRange(n, this.size());
        Iterator iterator = collection.iterator();
        int n2 = n;
        int n3 = Math.min(this.size() - n, collection.size());
        for (int i = 0; i < n3; ++i) {
            this.set(n2++, ((Number)iterator.next()).shortValue());
        }
    }

    public boolean retainAll(AbstractShortList abstractShortList) {
        int n;
        if (abstractShortList.size() == 0) {
            if (this.size == 0) {
                return false;
            }
            this.setSize(0);
            return true;
        }
        int n2 = abstractShortList.size() - 1;
        int n3 = 0;
        for (n = 0; n < this.size; ++n) {
            if (abstractShortList.indexOfFromTo(this.getQuick(n), 0, n2) < 0) continue;
            this.setQuick(n3++, this.getQuick(n));
        }
        n = n3 != this.size ? 1 : 0;
        this.setSize(n3);
        return n != 0;
    }

    public void reverse() {
        int n = this.size() / 2;
        int n2 = this.size() - 1;
        int n3 = 0;
        while (n3 < n) {
            short s2 = this.getQuick(n3);
            this.setQuick(n3++, this.getQuick(n2));
            this.setQuick(n2--, s2);
        }
    }

    public void set(int n, short s2) {
        if (n >= this.size || n < 0) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        this.setQuick(n, s2);
    }

    protected abstract void setQuick(int var1, short var2);

    protected void setSizeRaw(int n) {
        this.size = n;
    }

    public void shuffleFromTo(int n, int n2) {
        AbstractShortList.checkRangeFromTo(n, n2, this.size());
        Uniform uniform = new Uniform(new DRand(new Date()));
        for (int i = n; i < n2; ++i) {
            int n3 = uniform.nextIntFromTo(i, n2);
            short s2 = this.getQuick(n3);
            this.setQuick(n3, this.getQuick(i));
            this.setQuick(i, s2);
        }
    }

    public int size() {
        return this.size;
    }

    public AbstractShortList times(int n) {
        ShortArrayList shortArrayList = new ShortArrayList(n * this.size());
        int n2 = n;
        while (--n2 >= 0) {
            shortArrayList.addAllOfFromTo(this, 0, this.size() - 1);
        }
        return shortArrayList;
    }

    public ArrayList toList() {
        int n = this.size();
        ArrayList<Short> arrayList = new ArrayList<Short>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Short(this.get(i)));
        }
        return arrayList;
    }

    public String toString() {
        return Arrays.toString(this.partFromTo(0, this.size() - 1).elements());
    }
}

