# Performance Evaluation Method Wrapper

## Description:

- enable prometheus addon:
```
tfs@tfs-vm:~/tfs-ctrl$ microk8s.enable prometheus
tfs@tfs-vm:~/tfs-ctrl$ microk8s.status --wait-ready
```

- deploy as:
```
tfs@tfs-vm:~/tfs-ctrl$ source src/common/perf_eval_method_wrapper/tests/deploy_specs.sh 
tfs@tfs-vm:~/tfs-ctrl$ ./deploy.sh 
```

- expose prometheus and grafana

  - terminal 1 (prometheus UI): `kubectl port-forward -n monitoring service/prometheus-k8s --address 0.0.0.0 9090:9090`
  - terminal 2 (grafana UI): `kubectl port-forward -n monitoring service/grafana --address 0.0.0.0 3000:3000`
  - terminal 3 (alertmanager UI): `kubectl port-forward -n monitoring service/alertmanager-main --address 0.0.0.0 9093:9093`

- if using remote server/VM for running MicroK8s and VSCode, forward ports 9090, 3000, 9093

terminal 4 (tun test_set):
```
export PYTHONPATH=/home/tfs/tfs-ctrl/src
python -m common.perf_eval_method_wrapper.tests.test_set
```

- log into grafana:
  - 127.0.0.1:3000
  - admin/admin
  - upload dashboard_prometheus_histogram.json
  - watch in real time the dashboard

- upload topology through WebUI and navigate
  - should see histogram changing in Grafana

## References:
- [Prometheus - Tutorials - Getting Started](https://prometheus.io/docs/tutorials/getting_started/)
- [Prometheus - Tutorials - Understanding metric types](https://prometheus.io/docs/tutorials/understanding_metric_types/)
- [Prometheus - Tutorials - Instrumenting HTTP server in Go](https://prometheus.io/docs/tutorials/instrumenting_http_server_in_go/)
- [Prometheus - Tutorials - Visualizing metrics using Grafana](https://prometheus.io/docs/tutorials/visualizing_metrics_using_grafana/)
- [Prometheus - Tutorials - Alerting based on metrics](https://prometheus.io/docs/tutorials/alerting_based_on_metrics/)
- [Prometheus Operator - Guide](https://www.infracloud.io/blogs/prometheus-operator-helm-guide/)
- [Prometheus Operator - ServiceMonitor definition](https://prometheus-operator.dev/docs/operator/api/#monitoring.coreos.com/v1.ServiceMonitor)
- [Prometheus Operator - ServiceMonitor example 1](https://stackoverflow.com/questions/45613660/how-do-you-add-scrape-targets-to-a-prometheus-server-that-was-installed-with-kub)
- [Prometheus Operator - ServiceMonitor example 2](https://stackoverflow.com/questions/52991038/how-to-create-a-servicemonitor-for-prometheus-operator)
- [How to visualize Prometheus histograms in Grafana](https://grafana.com/blog/2020/06/23/how-to-visualize-prometheus-histograms-in-grafana/)
