import json
from copy import deepcopy
from typing import Any, Dict, Union
from device.proto.context_pb2 import ConfigActionEnum

def config_rule(action : ConfigActionEnum, resource_key : str, resource_value : Union[str, Dict[str, Any]]):
    if not isinstance(resource_value, str): resource_value = json.dumps(resource_value, sort_keys=True)
    return {'action': action, 'resource_key': resource_key, 'resource_value': resource_value}

def config_rule_set(resource_key : str, resource_value : Union[str, Dict[str, Any]]):
    return config_rule(ConfigActionEnum.CONFIGACTION_SET, resource_key, resource_value)

def config_rule_delete(resource_key : str, resource_value : Union[str, Dict[str, Any]]):
    return config_rule(ConfigActionEnum.CONFIGACTION_DELETE, resource_key, resource_value)

def endpoint_id(topology_id, device_id, endpoint_uuid):
    return {'topology_id': deepcopy(topology_id), 'device_id': deepcopy(device_id),
            'endpoint_uuid': {'uuid': endpoint_uuid}}

def endpoint(topology_id, device_id, endpoint_uuid, endpoint_type):
    return {'endpoint_id': endpoint_id(topology_id, device_id, endpoint_uuid), 'endpoint_type': endpoint_type}
