package eu.teraflow.policy.model;

import eu.teraflow.policy.context.model.ContextId;
import eu.teraflow.policy.context.model.ServiceId;

public class PolicyRule {

    private final PolicyRuleId policyRuleId;
    private final PolicyRuleType policyRuleType;
    private final PolicyRulePriority policyRulePriority;
    private final PolicyRuleEvent policyRuleEvent;
    private final PolicyRuleCondition policyRuleCondition;
    private final PolicyRuleAction policyRuleAction;
    private final ServiceId serviceId;
    private final ContextId contextId;

    public PolicyRule(
            PolicyRuleId policyRuleId,
            PolicyRuleType policyRuleType,
            PolicyRulePriority policyRulePriority,
            PolicyRuleEvent policyRuleEvent,
            PolicyRuleCondition policyRuleCondition,
            PolicyRuleAction policyRuleAction,
            ServiceId serviceId,
            ContextId contextId) {
        this.policyRuleId = policyRuleId;
        this.policyRuleType = policyRuleType;
        this.policyRulePriority = policyRulePriority;
        this.policyRuleEvent = policyRuleEvent;
        this.policyRuleCondition = policyRuleCondition;
        this.policyRuleAction = policyRuleAction;
        this.serviceId = serviceId;
        this.contextId = contextId;
    }

    public PolicyRuleId getPolicyRuleId() {
        return policyRuleId;
    }

    public PolicyRuleType getPolicyRuleType() {
        return policyRuleType;
    }

    public PolicyRulePriority getPolicyRulePriority() {
        return policyRulePriority;
    }

    public PolicyRuleEvent getPolicyRuleEvent() {
        return policyRuleEvent;
    }

    public PolicyRuleCondition getPolicyRuleCondition() {
        return policyRuleCondition;
    }

    public PolicyRuleAction getPolicyRuleAction() {
        return policyRuleAction;
    }

    public ServiceId getServiceId() {
        return serviceId;
    }

    public ContextId getContextId() {
        return contextId;
    }
}
