import logging, os, signal, sys, threading
import time

from context.client.ContextClient import ContextClient
from monitoring.Config import GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD, LOG_LEVEL, METRICS_PORT

from common.logger import getJSONLogger
from monitoring.client.monitoring_client import MonitoringClient
from monitoring.proto import monitoring_pb2
from monitoring.service.EventTools import EventsDeviceCollector
from monitoring.service.MonitoringService import MonitoringService

LOGGER = getJSONLogger('monitoringservice-server')
LOGGER.setLevel('DEBUG')

from prometheus_client import start_http_server

terminate = threading.Event()
logger = None

def signal_handler(signal, frame):
    global terminate, logger
    LOGGER.warning('Terminate signal received')
    terminate.set()

def start_monitoring():
    LOGGER.info('Start Monitoring...')
    context_client_grpc = ContextClient(address='localhost', port='2020')
    monitoring_client = MonitoringClient(server='localhost', port='7070')  # instantiate the client

    while True:
        if terminate.is_set():
            LOGGER.warning("Stopping execution...")

            break

        # Start Listening Events
        events_collector = EventsDeviceCollector(context_client_grpc, monitoring_client)
        events_collector.start()

        list_new_kpi_ids = events_collector.listen_events()

        # Monitor Kpis
        if bool(list_new_kpi_ids):
            for kpi_id in list_new_kpi_ids:
                # Create Monitor Kpi Requests
                monitor_kpi_request = monitoring_pb2.MonitorKpiRequest()
                monitor_kpi_request.kpi_id.CopyFrom(kpi_id)
                monitor_kpi_request.sampling_duration_s = 120
                monitor_kpi_request.sampling_interval_s = 5

                # MonitorKpi(monitor_kpi_request)




def main():
    global terminate, logger

    service_port = GRPC_SERVICE_PORT
    max_workers  = GRPC_MAX_WORKERS
    grace_period = GRPC_GRACE_PERIOD
    log_level    = LOG_LEVEL
    metrics_port = METRICS_PORT

    logging.basicConfig(level=log_level)
    logger = logging.getLogger(__name__)

    signal.signal(signal.SIGINT,  signal_handler)
    signal.signal(signal.SIGTERM, signal_handler)

    logger.info('Starting...')
    # Start metrics server
    start_http_server(metrics_port)

    # Starting monitoring service
    grpc_service = MonitoringService(port=service_port, max_workers=max_workers, grace_period=grace_period)
    grpc_service.start()

    # start_monitoring()

    # Wait for Ctrl+C or termination signal
    while not terminate.wait(timeout=0.1): pass

    logger.info('Terminating...')
    grpc_service.stop()

    logger.info('Bye')
    return 0

if __name__ == '__main__':
    sys.exit(main())