/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common.reedsolomon;

import com.google.zxing.common.reedsolomon.GF256;

final class GF256Poly {
    private final GF256 field;
    private final int[] coefficients;

    GF256Poly(GF256 gF256, int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = gF256;
        int n = nArray.length;
        if (n > 1 && nArray[0] == 0) {
            int n2;
            for (n2 = 1; n2 < n && nArray[n2] == 0; ++n2) {
            }
            if (n2 == n) {
                this.coefficients = gF256.getZero().coefficients;
            } else {
                this.coefficients = new int[n - n2];
                System.arraycopy(nArray, n2, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n) {
        return this.coefficients[this.coefficients.length - 1 - n];
    }

    int evaluateAt(int n) {
        if (n == 0) {
            return this.getCoefficient(0);
        }
        int n2 = this.coefficients.length;
        if (n == 1) {
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                n3 = GF256.addOrSubtract(n3, this.coefficients[i]);
            }
            return n3;
        }
        int n4 = this.coefficients[0];
        for (int i = 1; i < n2; ++i) {
            n4 = GF256.addOrSubtract(this.field.multiply(n, n4), this.coefficients[i]);
        }
        return n4;
    }

    GF256Poly addOrSubtract(GF256Poly gF256Poly) {
        int[] nArray;
        if (!this.field.equals(gF256Poly.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero()) {
            return gF256Poly;
        }
        if (gF256Poly.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = gF256Poly.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n);
        for (int i = n; i < nArray3.length; ++i) {
            nArray[i] = GF256.addOrSubtract(nArray2[i - n], nArray3[i]);
        }
        return new GF256Poly(this.field, nArray);
    }

    GF256Poly multiply(GF256Poly gF256Poly) {
        if (!this.field.equals(gF256Poly.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (this.isZero() || gF256Poly.isZero()) {
            return this.field.getZero();
        }
        int[] nArray = this.coefficients;
        int n = nArray.length;
        int[] nArray2 = gF256Poly.coefficients;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n + n2 - 1];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray3[i + j] = GF256.addOrSubtract(nArray3[i + j], this.field.multiply(n3, nArray2[j]));
            }
        }
        return new GF256Poly(this.field, nArray3);
    }

    GF256Poly multiply(int n) {
        if (n == 0) {
            return this.field.getZero();
        }
        if (n == 1) {
            return this;
        }
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.field.multiply(this.coefficients[i], n);
        }
        return new GF256Poly(this.field, nArray);
    }

    GF256Poly multiplyByMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.field.getZero();
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3 + n];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.field.multiply(this.coefficients[i], n2);
        }
        return new GF256Poly(this.field, nArray);
    }

    GF256Poly[] divide(GF256Poly gF256Poly) {
        if (!this.field.equals(gF256Poly.field)) {
            throw new IllegalArgumentException("GF256Polys do not have same GF256 field");
        }
        if (gF256Poly.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        GF256Poly gF256Poly2 = this.field.getZero();
        GF256Poly gF256Poly3 = this;
        int n = gF256Poly.getCoefficient(gF256Poly.getDegree());
        int n2 = this.field.inverse(n);
        while (gF256Poly3.getDegree() >= gF256Poly.getDegree() && !gF256Poly3.isZero()) {
            int n3 = gF256Poly3.getDegree() - gF256Poly.getDegree();
            int n4 = this.field.multiply(gF256Poly3.getCoefficient(gF256Poly3.getDegree()), n2);
            GF256Poly gF256Poly4 = gF256Poly.multiplyByMonomial(n3, n4);
            GF256Poly gF256Poly5 = this.field.buildMonomial(n3, n4);
            gF256Poly2 = gF256Poly2.addOrSubtract(gF256Poly5);
            gF256Poly3 = gF256Poly3.addOrSubtract(gF256Poly4);
        }
        return new GF256Poly[]{gF256Poly2, gF256Poly3};
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.getDegree());
        for (int i = this.getDegree(); i >= 0; --i) {
            int n = this.getCoefficient(i);
            if (n == 0) continue;
            if (n < 0) {
                stringBuffer.append(" - ");
                n = -n;
            } else if (stringBuffer.length() > 0) {
                stringBuffer.append(" + ");
            }
            if (i == 0 || n != 1) {
                int n2 = this.field.log(n);
                if (n2 == 0) {
                    stringBuffer.append('1');
                } else if (n2 == 1) {
                    stringBuffer.append('a');
                } else {
                    stringBuffer.append("a^");
                    stringBuffer.append(n2);
                }
            }
            if (i == 0) continue;
            if (i == 1) {
                stringBuffer.append('x');
                continue;
            }
            stringBuffer.append("x^");
            stringBuffer.append(i);
        }
        return stringBuffer.toString();
    }
}

