# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server.models.tapi_common_local_class import TapiCommonLocalClass  # noqa: F401,E501
from tapi_server.models.tapi_common_name_and_value import TapiCommonNameAndValue  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_connection_end_point_ref import TapiConnectivityConnectionEndPointRef  # noqa: F401,E501
from tapi_server.models.tapi_connectivity_resilience_route import TapiConnectivityResilienceRoute  # noqa: F401,E501
from tapi_server import util


class TapiConnectivityRoute(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, name: List[TapiCommonNameAndValue]=None, local_id: str=None, connection_end_point: List[TapiConnectivityConnectionEndPointRef]=None, resilience_route_pac: TapiConnectivityResilienceRoute=None):  # noqa: E501
        """TapiConnectivityRoute - a model defined in Swagger

        :param name: The name of this TapiConnectivityRoute.  # noqa: E501
        :type name: List[TapiCommonNameAndValue]
        :param local_id: The local_id of this TapiConnectivityRoute.  # noqa: E501
        :type local_id: str
        :param connection_end_point: The connection_end_point of this TapiConnectivityRoute.  # noqa: E501
        :type connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        :param resilience_route_pac: The resilience_route_pac of this TapiConnectivityRoute.  # noqa: E501
        :type resilience_route_pac: TapiConnectivityResilienceRoute
        """
        self.swagger_types = {
            'name': List[TapiCommonNameAndValue],
            'local_id': str,
            'connection_end_point': List[TapiConnectivityConnectionEndPointRef],
            'resilience_route_pac': TapiConnectivityResilienceRoute
        }

        self.attribute_map = {
            'name': 'name',
            'local_id': 'local-id',
            'connection_end_point': 'connection-end-point',
            'resilience_route_pac': 'resilience-route-pac'
        }
        self._name = name
        self._local_id = local_id
        self._connection_end_point = connection_end_point
        self._resilience_route_pac = resilience_route_pac

    @classmethod
    def from_dict(cls, dikt) -> 'TapiConnectivityRoute':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.connectivity.Route of this TapiConnectivityRoute.  # noqa: E501
        :rtype: TapiConnectivityRoute
        """
        return util.deserialize_model(dikt, cls)

    @property
    def name(self) -> List[TapiCommonNameAndValue]:
        """Gets the name of this TapiConnectivityRoute.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :return: The name of this TapiConnectivityRoute.
        :rtype: List[TapiCommonNameAndValue]
        """
        return self._name

    @name.setter
    def name(self, name: List[TapiCommonNameAndValue]):
        """Sets the name of this TapiConnectivityRoute.

        List of names. A property of an entity with a value that is unique in some namespace but may change during the life of the entity. A name carries no semantics with respect to the purpose of the entity.  # noqa: E501

        :param name: The name of this TapiConnectivityRoute.
        :type name: List[TapiCommonNameAndValue]
        """

        self._name = name

    @property
    def local_id(self) -> str:
        """Gets the local_id of this TapiConnectivityRoute.

        none  # noqa: E501

        :return: The local_id of this TapiConnectivityRoute.
        :rtype: str
        """
        return self._local_id

    @local_id.setter
    def local_id(self, local_id: str):
        """Sets the local_id of this TapiConnectivityRoute.

        none  # noqa: E501

        :param local_id: The local_id of this TapiConnectivityRoute.
        :type local_id: str
        """

        self._local_id = local_id

    @property
    def connection_end_point(self) -> List[TapiConnectivityConnectionEndPointRef]:
        """Gets the connection_end_point of this TapiConnectivityRoute.

        none  # noqa: E501

        :return: The connection_end_point of this TapiConnectivityRoute.
        :rtype: List[TapiConnectivityConnectionEndPointRef]
        """
        return self._connection_end_point

    @connection_end_point.setter
    def connection_end_point(self, connection_end_point: List[TapiConnectivityConnectionEndPointRef]):
        """Sets the connection_end_point of this TapiConnectivityRoute.

        none  # noqa: E501

        :param connection_end_point: The connection_end_point of this TapiConnectivityRoute.
        :type connection_end_point: List[TapiConnectivityConnectionEndPointRef]
        """

        self._connection_end_point = connection_end_point

    @property
    def resilience_route_pac(self) -> TapiConnectivityResilienceRoute:
        """Gets the resilience_route_pac of this TapiConnectivityRoute.


        :return: The resilience_route_pac of this TapiConnectivityRoute.
        :rtype: TapiConnectivityResilienceRoute
        """
        return self._resilience_route_pac

    @resilience_route_pac.setter
    def resilience_route_pac(self, resilience_route_pac: TapiConnectivityResilienceRoute):
        """Sets the resilience_route_pac of this TapiConnectivityRoute.


        :param resilience_route_pac: The resilience_route_pac of this TapiConnectivityRoute.
        :type resilience_route_pac: TapiConnectivityResilienceRoute
        """

        self._resilience_route_pac = resilience_route_pac
