# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from tapi_server.models.base_model_ import Model
from tapi_server import util


class TapiTopologyPortRoleRule(Model):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    def __init__(self, port_role_rule: List[str]=None, port_role: List[str]=None):  # noqa: E501
        """TapiTopologyPortRoleRule - a model defined in Swagger

        :param port_role_rule: The port_role_rule of this TapiTopologyPortRoleRule.  # noqa: E501
        :type port_role_rule: List[str]
        :param port_role: The port_role of this TapiTopologyPortRoleRule.  # noqa: E501
        :type port_role: List[str]
        """
        self.swagger_types = {
            'port_role_rule': List[str],
            'port_role': List[str]
        }

        self.attribute_map = {
            'port_role_rule': 'port-role-rule',
            'port_role': 'port-role'
        }
        self._port_role_rule = port_role_rule
        self._port_role = port_role

    @classmethod
    def from_dict(cls, dikt) -> 'TapiTopologyPortRoleRule':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The tapi.topology.PortRoleRule of this TapiTopologyPortRoleRule.  # noqa: E501
        :rtype: TapiTopologyPortRoleRule
        """
        return util.deserialize_model(dikt, cls)

    @property
    def port_role_rule(self) -> List[str]:
        """Gets the port_role_rule of this TapiTopologyPortRoleRule.

        Where the rule references more than one port role or where there are rule intersections either as a result of overlay of rules or inter rule group usage indicates role matching criteria for a connection following the rules.                  For example if two port roles, 'a' and 'b', are listed and the port role rule is 'different', this means that a connection connecting points in that group must have port roles that are different for each CEP in that group.                  In the example if a connection can have n ports of role 'a' and m ports of role 'b' then a maximum of two ports can be drawn from the NEPs of the group and where there are two, one must be role 'a' and one must be role 'b'.  # noqa: E501

        :return: The port_role_rule of this TapiTopologyPortRoleRule.
        :rtype: List[str]
        """
        return self._port_role_rule

    @port_role_rule.setter
    def port_role_rule(self, port_role_rule: List[str]):
        """Sets the port_role_rule of this TapiTopologyPortRoleRule.

        Where the rule references more than one port role or where there are rule intersections either as a result of overlay of rules or inter rule group usage indicates role matching criteria for a connection following the rules.                  For example if two port roles, 'a' and 'b', are listed and the port role rule is 'different', this means that a connection connecting points in that group must have port roles that are different for each CEP in that group.                  In the example if a connection can have n ports of role 'a' and m ports of role 'b' then a maximum of two ports can be drawn from the NEPs of the group and where there are two, one must be role 'a' and one must be role 'b'.  # noqa: E501

        :param port_role_rule: The port_role_rule of this TapiTopologyPortRoleRule.
        :type port_role_rule: List[str]
        """

        self._port_role_rule = port_role_rule

    @property
    def port_role(self) -> List[str]:
        """Gets the port_role of this TapiTopologyPortRoleRule.

        The role(s) of the port(s) considered in the rule.  # noqa: E501

        :return: The port_role of this TapiTopologyPortRoleRule.
        :rtype: List[str]
        """
        return self._port_role

    @port_role.setter
    def port_role(self, port_role: List[str]):
        """Sets the port_role of this TapiTopologyPortRoleRule.

        The role(s) of the port(s) considered in the rule.  # noqa: E501

        :param port_role: The port_role of this TapiTopologyPortRoleRule.
        :type port_role: List[str]
        """

        self._port_role = port_role
