# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
from bitarray import bitarray
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class config(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module openconfig-interfaces - based on the path /interfaces/interface/config. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Configurable items at the global, physical interface
level
  """
  __slots__ = ('_path_helper', '_extmethods', '__name','__type','__mtu','__loopback_mode','__description','__enabled',)

  _yang_name = 'config'
  _yang_namespace = 'http://openconfig.net/yang/interfaces'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['interfaces', 'interface', 'config']

  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /interfaces/interface/config/name (string)

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /interfaces/interface/config/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: The name of the interface.

A device MAY restrict the allowed values for this leaf,
possibly depending on the type of the interface.
For system-controlled interfaces, this leaf is the
device-specific name of the interface.  The 'config false'
list interfaces/interface[name]/state contains the currently
existing interfaces on the device.

If a client tries to create configuration for a
system-controlled interface that is not present in the
corresponding state list, the server MAY reject
the request if the implementation does not support
pre-provisioning of interfaces or if the name refers to
an interface that can never exist in the system.  A
NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.

The IETF model in RFC 7223 provides YANG features for the
following (i.e., pre-provisioning and arbitrary-names),
however they are omitted here:

 If the device supports pre-provisioning of interface
 configuration, the 'pre-provisioning' feature is
 advertised.

 If the device allows arbitrarily named user-controlled
 interfaces, the 'arbitrary-names' feature is advertised.

When a configured user-controlled interface is created by
the system, it is instantiated with the same name in the
/interfaces/interface[name]/state list.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_type(self):
    """
    Getter method for type, mapped from YANG variable /interfaces/interface/config/type (identityref)

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    return self.__type
      
  def _set_type(self, v, load=False):
    """
    Setter method for type, mapped from YANG variable /interfaces/interface/config/type (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_type() directly.

    YANG Description: The type of the interface.

When an interface entry is created, a server MAY
initialize the type leaf with a valid value, e.g., if it
is possible to derive the type from the name of the
interface.

If a client tries to set the type of an interface to a
value that can never be used by the system, e.g., if the
type is not supported or if the type does not match the
name of the interface, the server MUST reject the request.
A NETCONF server MUST reply with an rpc-error with the
error-tag 'invalid-value' in this case.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """type must be of a type compatible with identityref""",
          'defined-type': "openconfig-interfaces:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)""",
        })

    self.__type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_type(self):
    self.__type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iana-interface-type': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:other': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:regular1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdh1822': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ddnX25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc877x25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernetCsmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88023Csmacd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88024TokenBus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025TokenRing': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88026Man': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:starLan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon10Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:proteon80Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hyperchannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fddi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:e1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:basicISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:primaryISDN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propPointToPointSerial': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ppp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:softwareLoopback': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ethernet3Mbit': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nsip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:slip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ultra': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds3': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rs232': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:para': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arcnetPlus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:miox25': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25ple': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88022llc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:localTalk': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayService': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v35': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hssi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:modem': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal5': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetPath': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetVT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:smdsIcip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propMultiplexor': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80212': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fibreChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hippiInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayInterconnect': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8023': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aflane8025': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cctEmul': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v11': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v36': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at64k': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g703at2mb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qllc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastEtherFX': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:channel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80211': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ibm370parChan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:escon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dlsw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdns': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isdnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapd': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rsrb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmLogical': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds0Bundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bsc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:async': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cnr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Dtr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:eplrs': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:arap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propCnls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hostPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:termPad': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frameRelayMPI': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x213': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025CRFPInt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:myrinet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEM': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXO': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFXS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEncap': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmDxi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmFuni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmIma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pppMultilinkBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverCdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverClaw': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:stackToStack': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualIpAddress': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:iso88025Fiber': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gigabitEthernet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lapf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:v37': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25mlp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x25huntGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:transpHdlc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:interleave': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:a12MppSwitch': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:coffee': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ces': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmSubInterface': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l2vlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:l3ipxvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalPowerline': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mediaMailOverIp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dcn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ipForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:msdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee1394': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:if-gsn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRccUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVirtual': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mplsTunnel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:srp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverFrameRelay': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:idsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:compositeLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ss7SigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propWirelessP2P': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frForward': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rfc1483': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:usb': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee8023adLag': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bgppolicyaccounting': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frf16MfrBundle': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Gatekeeper': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:h323Proxy': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpls': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mfSigLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:shdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ds1FDL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pos': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiIn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbAsiOut': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:plc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:nfas': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:tr008': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303RDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gr303IDT': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:isup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessMaclayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propDocsWirelessUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:hiperlan2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propBWAp2Mp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sonetOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:digitalWrapperOverheadChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aal2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:radioMAC': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:imt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mvl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:reachDSL': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:frDlciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmVciEndPt': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:propAtm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceOverCable': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:infiniband': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:teLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:q2931': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:virtualTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipTg': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sipSig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamChannel': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:econet': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon155': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pon622': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bridge': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:linegroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEMFGD': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDEANA': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceDID': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mpegTransport': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sixToFour': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gtp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pdnEtherLoop2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:opticalChannelGroup': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:homepna': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ciscoISLvlan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:actelisMetaLOOP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fcipLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:rpr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:qam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:lmp': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cblVectaStar': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableMCmtsDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecControlledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:macSecUncontrolledIF': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aviciOpticalEther': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:atmbond': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceFGDOS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:mocaVersion1': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee80216WMAN': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:adsl2plus': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsMacLayer': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbTdm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:dvbRcsTdma': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:x86Laps': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:wwanPP2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:voiceEBS': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifPwType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ilan': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:pip': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluELP': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vdsl2': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Profile': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapDot11Bss': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:capwapWtpVirtualRadio': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:bits': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableUpstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:cableDownstreamRfPort': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareVirtualNic': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ieee802154': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOdu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ifVfiType': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9981': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9982': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:g9983': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEpon': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluEponLogicalLink': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponOnu': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:aluGponPhysicalUni': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:vmwareNicTeam': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmDownstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsOfdmaUpstream': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:gfast': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:sdci': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:xboxWireless': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:fastdsl': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1FwdOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d1RetOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2DsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableScte55d2UsOob': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdf': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:docsCableNdr': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ptm': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:ghn': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsi': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtuc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOduc': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:otnOtsig': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveCarrierTermination': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}, 'ianaift:microwaveRadioLinkTerminal': {'@module': 'iana-if-type', '@namespace': 'urn:ietf:params:xml:ns:yang:iana-if-type'}},), is_leaf=True, yang_name="type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='identityref', is_config=True)


  def _get_mtu(self):
    """
    Getter method for mtu, mapped from YANG variable /interfaces/interface/config/mtu (uint16)

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    return self.__mtu
      
  def _set_mtu(self, v, load=False):
    """
    Setter method for mtu, mapped from YANG variable /interfaces/interface/config/mtu (uint16)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_mtu is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_mtu() directly.

    YANG Description: Set the max transmission unit size in octets
for the physical interface.  If this is not set, the mtu is
set to the operational default -- e.g., 1514 bytes on an
Ethernet interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """mtu must be of a type compatible with uint16""",
          'defined-type': "uint16",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)""",
        })

    self.__mtu = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_mtu(self):
    self.__mtu = YANGDynClass(base=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), is_leaf=True, yang_name="mtu", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='uint16', is_config=True)


  def _get_loopback_mode(self):
    """
    Getter method for loopback_mode, mapped from YANG variable /interfaces/interface/config/loopback_mode (boolean)

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    return self.__loopback_mode
      
  def _set_loopback_mode(self, v, load=False):
    """
    Setter method for loopback_mode, mapped from YANG variable /interfaces/interface/config/loopback_mode (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_loopback_mode is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_loopback_mode() directly.

    YANG Description: When set to true, the interface is logically looped back,
such that packets that are forwarded via the interface
are received on the same interface.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """loopback_mode must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__loopback_mode = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_loopback_mode(self):
    self.__loopback_mode = YANGDynClass(base=YANGBool, default=YANGBool("false"), is_leaf=True, yang_name="loopback-mode", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)


  def _get_description(self):
    """
    Getter method for description, mapped from YANG variable /interfaces/interface/config/description (string)

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    return self.__description
      
  def _set_description(self, v, load=False):
    """
    Setter method for description, mapped from YANG variable /interfaces/interface/config/description (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_description is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_description() directly.

    YANG Description: A textual description of the interface.

A server implementation MAY map this leaf to the ifAlias
MIB object.  Such an implementation needs to use some
mechanism to handle the differences in size and characters
allowed between this leaf and ifAlias.  The definition of
such a mechanism is outside the scope of this document.

Since ifAlias is defined to be stored in non-volatile
storage, the MIB implementation MUST map ifAlias to the
value of 'description' in the persistently stored
datastore.

Specifically, if the device supports ':startup', when
ifAlias is read the device MUST return the value of
'description' in the 'startup' datastore, and when it is
written, it MUST be written to the 'running' and 'startup'
datastores.  Note that it is up to the implementation to

decide whether to modify this single leaf in 'startup' or
perform an implicit copy-config from 'running' to
'startup'.

If the device does not support ':startup', ifAlias MUST
be mapped to the 'description' leaf in the 'running'
datastore.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """description must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)""",
        })

    self.__description = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_description(self):
    self.__description = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="description", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='string', is_config=True)


  def _get_enabled(self):
    """
    Getter method for enabled, mapped from YANG variable /interfaces/interface/config/enabled (boolean)

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    return self.__enabled
      
  def _set_enabled(self, v, load=False):
    """
    Setter method for enabled, mapped from YANG variable /interfaces/interface/config/enabled (boolean)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enabled is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enabled() directly.

    YANG Description: This leaf contains the configured, desired state of the
interface.

Systems that implement the IF-MIB use the value of this
leaf in the 'running' datastore to set
IF-MIB.ifAdminStatus to 'up' or 'down' after an ifEntry
has been initialized, as described in RFC 2863.

Changes in this leaf in the 'running' datastore are
reflected in ifAdminStatus, but if ifAdminStatus is
changed over SNMP, this leaf is not affected.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enabled must be of a type compatible with boolean""",
          'defined-type': "boolean",
          'generated-type': """YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)""",
        })

    self.__enabled = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enabled(self):
    self.__enabled = YANGDynClass(base=YANGBool, default=YANGBool("true"), is_leaf=True, yang_name="enabled", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='http://openconfig.net/yang/interfaces', defining_module='openconfig-interfaces', yang_type='boolean', is_config=True)

  name = __builtin__.property(_get_name, _set_name)
  type = __builtin__.property(_get_type, _set_type)
  mtu = __builtin__.property(_get_mtu, _set_mtu)
  loopback_mode = __builtin__.property(_get_loopback_mode, _set_loopback_mode)
  description = __builtin__.property(_get_description, _set_description)
  enabled = __builtin__.property(_get_enabled, _set_enabled)


  _pyangbind_elements = OrderedDict([('name', name), ('type', type), ('mtu', mtu), ('loopback_mode', loopback_mode), ('description', description), ('enabled', enabled), ])


