from influxdb import InfluxDBClient

class Influx():
  def __init__(self, host, port, username, password, database):
      self.client = InfluxDBClient(host=host, port=port, username=username, password=password, database=database)

  def write_KPI(self,time,device_id,kpi_sample_type,kpi_value):
    data = [{
      "measurement": "samples",
      "time": time,
      "tags": {
          "device_id"  : device_id,
          "kpi_sample_type": kpi_sample_type
      },
      "fields": {
          
          "kpi_value": kpi_value
      }
    }]
    self.client.write_points(data)