import logging, pytest
from google.protobuf.json_format import MessageToDict
from common.tests.Assertions import validate_service_id
from compute.client.ComputeClient import ComputeClient
from compute.proto.service_pb2 import Service
from compute.service.ComputeService import ComputeService
from compute.Config import GRPC_SERVICE_PORT, GRPC_MAX_WORKERS, GRPC_GRACE_PERIOD

grpc_port = 10000 + GRPC_SERVICE_PORT # avoid privileged ports

LOGGER = logging.getLogger(__name__)
LOGGER.setLevel(logging.DEBUG)

@pytest.fixture(scope='session')
def compute_service():
    _service = ComputeService(port=grpc_port, max_workers=GRPC_MAX_WORKERS, grace_period=GRPC_GRACE_PERIOD)
    _service.start()
    yield _service
    _service.stop()

@pytest.fixture(scope='session')
def compute_client(compute_service):
    _client = ComputeClient(address='127.0.0.1', port=grpc_port)
    yield _client
    _client.close()

def test_dummy_create_connectivity_service(compute_client : ComputeClient):
    # dummy test: should fail with assertion error
    with pytest.raises(AssertionError):
        validate_service_id(MessageToDict(
            compute_client.CreateConnectivityService(Service()),
            including_default_value_fields=True, preserving_proto_field_name=True,
            use_integers_for_enums=False))
