%%%-----------------------------------------------------------------------------
%% @doc tfte service supervisor.
%% @end
%%%-----------------------------------------------------------------------------

-module(tfte_service_sup).

-behaviour(supervisor).


%%% EXPORTS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% API Functions
-export([start_link/0]).

% Behaviour supervisor callback functions
-export([init/1]).


%%% MACROS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

-define(SERVER, ?MODULE).


%%% API FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

start_link() ->
    supervisor:start_link({local, ?SERVER}, ?MODULE, []).


%%% BEHAVIOUR supervisor CALLBACK FUNCTIONS %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

init([]) ->
    SupFlags = #{strategy => one_for_one,
                 intensity => 0,
                 period => 1},
    ContextSpec = #{
        id => tfte_context,
        start => {tfte_context, start_link, []},
        restart => permanent,
        shutdown => brutal_kill
    },
    TopologySpec = #{
        id => tfte_topology,
        start => {tfte_topology, start_link, []},
        restart => permanent,
        shutdown => brutal_kill
    },
    ChildSpecs = [ContextSpec, TopologySpec],
    {ok, {SupFlags, ChildSpecs}}.
