# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from ..service_handler_api.FilterFields import FilterFieldEnum, ORM_DeviceDriverEnum, ORM_ServiceTypeEnum
from .l2nm_emulated.L2NMEmulatedServiceHandler import L2NMEmulatedServiceHandler
from .l3nm_emulated.L3NMEmulatedServiceHandler import L3NMEmulatedServiceHandler
from .l3nm_openconfig.L3NMOpenConfigServiceHandler import L3NMOpenConfigServiceHandler
from .tapi_tapi.TapiServiceHandler import TapiServiceHandler

SERVICE_HANDLERS = [
    (L2NMEmulatedServiceHandler, [
        {
            FilterFieldEnum.SERVICE_TYPE  : ORM_ServiceTypeEnum.L2NM,
            FilterFieldEnum.DEVICE_DRIVER : ORM_DeviceDriverEnum.UNDEFINED,
        }
    ]),
    (L3NMEmulatedServiceHandler, [
        {
            FilterFieldEnum.SERVICE_TYPE  : ORM_ServiceTypeEnum.L3NM,
            FilterFieldEnum.DEVICE_DRIVER : ORM_DeviceDriverEnum.UNDEFINED,
        }
    ]),
    (L3NMOpenConfigServiceHandler, [
        {
            FilterFieldEnum.SERVICE_TYPE  : ORM_ServiceTypeEnum.L3NM,
            FilterFieldEnum.DEVICE_DRIVER : ORM_DeviceDriverEnum.OPENCONFIG,
        }
    ]),
    (TapiServiceHandler, [
        {
            FilterFieldEnum.SERVICE_TYPE  : ORM_ServiceTypeEnum.TAPI_CONNECTIVITY_SERVICE,
            FilterFieldEnum.DEVICE_DRIVER : ORM_DeviceDriverEnum.TRANSPORT_API,
        }
    ]),
]
