/*
 * Decompiled with CFR 0.152.
 */
package jcckit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import jcckit.graphic.GraphicalElement;
import jcckit.graphic.Renderer;
import jcckit.plot.Plot;
import jcckit.plot.PlotCanvas;
import jcckit.renderer.Graphics2DRenderer;
import jcckit.renderer.Transformation;
import jcckit.util.ConfigParameters;
import jcckit.util.Factory;

public class GraphicsPlotCanvas
extends PlotCanvas {
    public static final String BACKGROUND_KEY = "background";
    public static final String FOREGROUND_KEY = "foreground";
    public static final String DOUBLE_BUFFERING_KEY = "doubleBuffering";
    private final BufferedImage img3;
    private final Graphics2D g3;
    private Transformation _transformation;
    private String _renderer = "jcckit.renderer.GraphicsRenderer";
    private GraphicalElement _marker;
    private final Color background;
    private final Color foreground;

    public GraphicsPlotCanvas(ConfigParameters configParameters, BufferedImage bufferedImage) {
        super(configParameters);
        this.img3 = bufferedImage;
        this.setRenderer("jcckit.renderer.Graphics2DRenderer");
        this.g3 = bufferedImage.createGraphics();
        this.g3.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.background = configParameters.getColor(BACKGROUND_KEY, Color.WHITE);
        this.foreground = configParameters.getColor(FOREGROUND_KEY, Color.BLACK);
    }

    public void paint() {
        Dimension dimension = new Dimension(this.img3.getWidth(), this.img3.getHeight());
        this.g3.setColor(this.background);
        this.g3.fillRect(0, 0, dimension.width + 1, dimension.height + 1);
        this.init(dimension);
        this._transformation.apply(this.g3);
        Plot plot = this.getPlot();
        this.drawCoordinateSystem(dimension, plot);
        this.drawPlot(plot);
        if (this._marker != null) {
            this._marker.renderWith(this.createRenderer());
        }
    }

    private void drawPlot(Plot plot) {
        this.prepare();
        Renderer renderer = this.createRenderer();
        GraphicalElement[] graphicalElementArray = plot.getCurves();
        for (int i = 0; i < graphicalElementArray.length; ++i) {
            graphicalElementArray[i].renderWith(renderer);
        }
        GraphicalElement graphicalElement = plot.getAnnotation();
        if (graphicalElement != null) {
            graphicalElement.renderWith(renderer);
        }
        if (plot.isLegendVisible()) {
            plot.getLegend().renderWith(renderer);
        }
    }

    private void init(Dimension dimension) {
        this.calculateTransformation(dimension);
    }

    private void drawCoordinateSystem(Dimension dimension, Plot plot) {
        this.g3.setColor(this.foreground);
        plot.getCoordinateSystem().renderWith(this.createRenderer());
    }

    protected void prepare() {
    }

    protected void calculateTransformation(Dimension dimension) {
        this._transformation = new Transformation(dimension.width, dimension.height, this.getPaper(), this.getHorizontalAnchor(), this.getVerticalAnchor());
    }

    protected Renderer createRenderer() {
        return ((Graphics2DRenderer)Factory.create(this._renderer)).init(this.g3);
    }

    public void setRenderer(String string) {
        this._renderer = string;
    }

    public void setMarker(GraphicalElement graphicalElement) {
        this._marker = graphicalElement;
    }
}

