# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class otn(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/local-link-connectivity/optimizations/optimization-metric/explicit-route-exclude-objects/route-object-exclude-object/label-hop/te-label/otn. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Label hop for OTN.
  """
  __slots__ = ('_path_helper', '_extmethods', '__tpn','__tsg','__ts_list',)

  _yang_name = 'otn'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__tpn = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)
    self.__tsg = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    self.__ts_list = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="ts-list", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='string', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'local-link-connectivity', 'optimizations', 'optimization-metric', 'explicit-route-exclude-objects', 'route-object-exclude-object', 'label-hop', 'te-label', 'otn']

  def _get_tpn(self):
    """
    Getter method for tpn, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object/label_hop/te_label/otn/tpn (otn-tpn)

    YANG Description: Tributary Port Number (TPN).
    """
    return self.__tpn
      
  def _set_tpn(self, v, load=False):
    """
    Setter method for tpn, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object/label_hop/te_label/otn/tpn (otn-tpn)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tpn is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tpn() directly.

    YANG Description: Tributary Port Number (TPN).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tpn must be of a type compatible with otn-tpn""",
          'defined-type': "ietf-otn-topology:otn-tpn",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)""",
        })

    self.__tpn = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tpn(self):
    self.__tpn = YANGDynClass(base=RestrictedClassType(base_type=RestrictedClassType(base_type=int, restriction_dict={'range': ['0..65535']},int_size=16), restriction_dict={'range': ['1..4095']}), is_leaf=True, yang_name="tpn", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='otn-tpn', is_config=True)


  def _get_tsg(self):
    """
    Getter method for tsg, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object/label_hop/te_label/otn/tsg (identityref)

    YANG Description: Tributary Slot Granularity (TSG).
    """
    return self.__tsg
      
  def _set_tsg(self, v, load=False):
    """
    Setter method for tsg, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object/label_hop/te_label/otn/tsg (identityref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_tsg is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_tsg() directly.

    YANG Description: Tributary Slot Granularity (TSG).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """tsg must be of a type compatible with identityref""",
          'defined-type': "ietf-otn-topology:identityref",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)""",
        })

    self.__tsg = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_tsg(self):
    self.__tsg = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_type="dict_key", restriction_arg={'tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-1.25G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-2.5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'ietf-layer1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}, 'l1-types:tsg-5G': {'@module': 'ietf-layer1-types', '@namespace': 'urn:ietf:params:xml:ns:yang:ietf-layer1-types'}},), is_leaf=True, yang_name="tsg", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='identityref', is_config=True)


  def _get_ts_list(self):
    """
    Getter method for ts_list, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object/label_hop/te_label/otn/ts_list (string)

    YANG Description: A list of available Tributary Slots (TS) ranging




between 1 and 4095. If multiple values or
ranges are given, they all MUST be disjoint
and MUST be in ascending order.
For example 1-20,25,50-1000.
    """
    return self.__ts_list
      
  def _set_ts_list(self, v, load=False):
    """
    Setter method for ts_list, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/local_link_connectivity/optimizations/optimization_metric/explicit_route_exclude_objects/route_object_exclude_object/label_hop/te_label/otn/ts_list (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_ts_list is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_ts_list() directly.

    YANG Description: A list of available Tributary Slots (TS) ranging




between 1 and 4095. If multiple values or
ranges are given, they all MUST be disjoint
and MUST be in ascending order.
For example 1-20,25,50-1000.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="ts-list", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='string', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """ts_list must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="ts-list", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='string', is_config=True)""",
        })

    self.__ts_list = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_ts_list(self):
    self.__ts_list = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '([1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?(,[1-9][0-9]{0,3}(-[1-9][0-9]{0,3})?)*)'}), is_leaf=True, yang_name="ts-list", parent=self, choice=('technology', 'otn'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='string', is_config=True)

  tpn = __builtin__.property(_get_tpn, _set_tpn)
  tsg = __builtin__.property(_get_tsg, _set_tsg)
  ts_list = __builtin__.property(_get_ts_list, _set_ts_list)

  __choices__ = {'technology': {'otn': ['tpn', 'tsg', 'ts_list']}}
  _pyangbind_elements = OrderedDict([('tpn', tpn), ('tsg', tsg), ('ts_list', ts_list), ])


