#########################
# NFV-SDN pending tasks
#########################

Preparation
-----------

IDC: on start
    - subscribe to Context events

DLT: on start
    - subscribe to DLT events
    - start gRPC server


Workflow #1 - Send/Receive changes through DLT
----------------------------------------------
IDC: subscribe to changes in Context
IDC: on event from context
        - if not change in local domain: return
        - compute abstraction
            - get local abstracted topology from context
            - update local abstracted topology
            - set local abstracted topology in context
        - convert changes to records
        - issue change records to DLT
        - on OK from DLT, end

DLT: on request to store record
        - store record on blockchain
        - retrieve status
        - check result

DLT: on event received
        - find record id in event
        - retrieve record using record id
        - update Context with data in record
        - check result


Workflow #2 - Activate inter-domain slices with SLAs
----------------------------------------------------

PathComp:
- request inter-domain context
- perform inter-domain pathcomp

Slice: CreateSlice
- detect type of request
- if not multi-domain, use local single-domain logic
- issue request to IDC

Slice: OrderSliceWithSLAs
- create service S
- associate policy

Policy: CreatePolicy
...

IDC:
- request to PathComp the inter-domain path
- parse returned inter-domain path
- for each domain involved
    - if local domain
        - request to Slice: OrderSliceWithSLAs
    - if remote domain
        - add record in DLT: (context=remote-domain)

DLT: on OrderSiceWithSLAs
    - issue request to IDC
    - would be local slice
    - request to Slice create slice, service, policy as usual
    - record slice updated in DLT


Workflow #3 - Resolve SLA violation on inter-domain slice
---------------------------------------------------------

