from enum import Enum

class ServiceState(Enum):
    PLANNED = 0
    ACTIVE = 1
    PENDING_REMOVAL = 2

ANY_TO_ENUM = {
    0: ServiceState.PLANNED,
    1: ServiceState.ACTIVE,
    2: ServiceState.PENDING_REMOVAL,

    '0': ServiceState.PLANNED,
    '1': ServiceState.ACTIVE,
    '2': ServiceState.PENDING_REMOVAL,

    'PLANNED': ServiceState.PLANNED,
    'ACTIVE': ServiceState.ACTIVE,
    'PENDING_REMOVAL': ServiceState.PENDING_REMOVAL,
}

def servicestate_enum_values():
    return {m.value for m in ServiceState.__members__.values()}

def to_servicestate_enum(int_or_str):
    if isinstance(int_or_str, str): int_or_str = int_or_str.lower()
    return ANY_TO_ENUM.get(int_or_str)
