# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import logging
from typing import Dict, List
from common.tools.object_factory.ConfigRule import json_config_rule_delete, json_config_rule_set
from service.service.service_handler_api.AnyTreeTools import TreeNode

LOGGER = logging.getLogger(__name__)

def setup_config_rules(
    service_uuid : str, connection_uuid : str, device_uuid : str, endpoint_uuid : str,
    service_settings : TreeNode, endpoint_settings : TreeNode
) -> List[Dict]:

    json_settings          : Dict = {} if service_settings  is None else service_settings.value
    json_endpoint_settings : Dict = {} if endpoint_settings is None else endpoint_settings.value

    json_config_rules = [
    ]
    return json_config_rules

def teardown_config_rules(
    service_uuid : str, connection_uuid : str, device_uuid : str, endpoint_uuid : str,
    service_settings : TreeNode, endpoint_settings : TreeNode
) -> List[Dict]:

    json_settings          : Dict = {} if service_settings  is None else service_settings.value
    json_endpoint_settings : Dict = {} if endpoint_settings is None else endpoint_settings.value

    json_config_rules = [
    ]
    return json_config_rules
