from typing import Iterator, Set, Tuple

class _Backend:
    def __init__(self, **settings) -> None:
        raise NotImplementedError()

    def terminate(self) -> None:
        raise NotImplementedError()

    def publish(self, topic_name : str, message_content : str) -> None:
        raise NotImplementedError()

    def consume(self, topic_names : Set[str], consume_timeout : float) -> Iterator[Tuple[str, str]]:
        raise NotImplementedError()
