/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.CollisionDetector;
import net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionCross;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddUrl;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAssembly;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateFork;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateGroup;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateSplit;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorIf;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorRepeat;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorWhile;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.VCompactFactory;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockInterceptorTextBlockable;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UGraphicDelegator;
import net.sourceforge.plantuml.svek.UGraphicForSnake;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class Swimlanes
implements TextBlock {
    private final ISkinParam skinParam;
    private final List<Swimlane> swinlanes = new ArrayList<Swimlane>();
    private final FontConfiguration fontConfiguration;
    private Swimlane currentSwimlane = null;
    private final Instruction root;
    private Instruction currentInstruction = this.root = new InstructionList();
    private LinkRendering nextLinkRenderer;
    static final double separationMargin = 10.0;

    public Swimlanes(ISkinParam iSkinParam) {
        this.skinParam = iSkinParam;
        UFont uFont = iSkinParam.getFont(FontParam.TITLE, null);
        this.fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK);
    }

    private FtileFactory getFtileFactory() {
        FtileFactory ftileFactory = new VCompactFactory(this.skinParam, TextBlockUtils.getDummyStringBounder());
        ftileFactory = new FtileFactoryDelegatorAddUrl(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorAssembly(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorIf(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorWhile(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorRepeat(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorCreateFork(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorCreateSplit(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorAddNote(ftileFactory, this.skinParam);
        ftileFactory = new FtileFactoryDelegatorCreateGroup(ftileFactory, this.skinParam);
        return ftileFactory;
    }

    public void swimlane(String string, HtmlColor htmlColor, Display display) {
        this.currentSwimlane = this.getOrCreate(string);
        if (htmlColor != null) {
            this.currentSwimlane.setSpecificBackcolor(htmlColor);
        }
        if (display != null) {
            this.currentSwimlane.setDisplay(display);
        }
    }

    private Swimlane getOrCreate(String string) {
        for (Swimlane swimlane : this.swinlanes) {
            if (!swimlane.getName().equals(string)) continue;
            return swimlane;
        }
        Swimlane swimlane = new Swimlane(string);
        this.swinlanes.add(swimlane);
        return swimlane;
    }

    public void drawU(UGraphic uGraphic) {
        FtileFactory ftileFactory = this.getFtileFactory();
        TextBlock textBlock = this.root.createFtile(ftileFactory);
        uGraphic = new UGraphicForSnake(uGraphic);
        if (this.swinlanes.size() <= 1) {
            textBlock = new TextBlockInterceptorTextBlockable(textBlock);
            textBlock.drawU(uGraphic);
            uGraphic.flushUg();
            return;
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        UTranslate uTranslate = this.getTitleHeightTranslate(stringBounder);
        this.computeSize(uGraphic, textBlock);
        double d = 0.0;
        for (Swimlane swimlane : this.swinlanes) {
            Object object;
            if (swimlane.getSpecificBackColor() != null) {
                object = uGraphic.apply(new UChangeBackColor(swimlane.getSpecificBackColor())).apply(new UChangeColor(swimlane.getSpecificBackColor())).apply(new UTranslate(d, 0.0));
                object.draw(new URectangle(swimlane.getTotalWidth(), dimension2D.getHeight() + uTranslate.getDy()));
            }
            object = TextBlockUtils.create(swimlane.getDisplay(), this.fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
            double d2 = object.calculateDimension(stringBounder).getWidth();
            double d3 = d + (swimlane.getTotalWidth() - d2) / 2.0;
            object.drawU(uGraphic.apply(new UTranslate(d3, 0.0)));
            this.drawSeparation(uGraphic.apply(new UTranslate(d, 0.0)), dimension2D.getHeight() + uTranslate.getDy());
            textBlock.drawU(new UGraphicInterceptorOneSwimlane(uGraphic, swimlane).apply(swimlane.getTranslate()).apply(uTranslate));
            d += swimlane.getTotalWidth();
        }
        this.drawSeparation(uGraphic.apply(new UTranslate(d, 0.0)), dimension2D.getHeight() + uTranslate.getDy());
        Cross cross = new Cross(uGraphic.apply(uTranslate));
        textBlock.drawU(cross);
        cross.flushUg();
    }

    private void computeSize(UGraphic uGraphic, TextBlock textBlock) {
        double d = 0.0;
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Swimlane swimlane : this.swinlanes) {
            LimitFinder limitFinder = new LimitFinder(stringBounder, false);
            UGraphicInterceptorOneSwimlane uGraphicInterceptorOneSwimlane = new UGraphicInterceptorOneSwimlane(new UGraphicForSnake(limitFinder), swimlane);
            textBlock.drawU(uGraphicInterceptorOneSwimlane);
            uGraphicInterceptorOneSwimlane.flushUg();
            MinMax minMax = limitFinder.getMinMax();
            double d2 = minMax.getWidth() + 20.0;
            TextBlock textBlock2 = TextBlockUtils.create(swimlane.getDisplay(), this.fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
            double d3 = textBlock2.calculateDimension(stringBounder).getWidth();
            double d4 = Math.max(d2, d3 + 20.0);
            UTranslate uTranslate = new UTranslate(d - minMax.getMinX() + 10.0 + (d4 - d2) / 2.0, 0.0);
            swimlane.setTranslateAndWidth(uTranslate, d4);
            d += d4;
        }
    }

    private UTranslate getTitleHeightTranslate(StringBounder stringBounder) {
        double d = 0.0;
        for (Swimlane swimlane : this.swinlanes) {
            TextBlock textBlock = TextBlockUtils.create(swimlane.getDisplay(), this.fontConfiguration, HorizontalAlignment.LEFT, this.skinParam);
            d = Math.max(d, textBlock.calculateDimension(stringBounder).getHeight());
        }
        UTranslate uTranslate = new UTranslate(0.0, d);
        return uTranslate;
    }

    private CollisionDetector getCollisionDetector(UGraphic uGraphic, UTranslate uTranslate) {
        FtileFactory ftileFactory = this.getFtileFactory();
        Ftile ftile = this.root.createFtile(ftileFactory);
        uGraphic = new UGraphicForSnake(uGraphic);
        CollisionDetector collisionDetector = new CollisionDetector(uGraphic.getStringBounder());
        for (Swimlane swimlane : this.swinlanes) {
            ftile.drawU(new UGraphicInterceptorOneSwimlane(collisionDetector, swimlane).apply(swimlane.getTranslate()).apply(uTranslate));
        }
        collisionDetector.setManageSnakes(true);
        Cross cross = new Cross(collisionDetector.apply(uTranslate));
        ftile.drawU(cross);
        cross.flushUg();
        return collisionDetector;
    }

    private void drawSeparation(UGraphic uGraphic, double d) {
        uGraphic.apply(new UStroke(2.0)).apply(new UChangeColor(HtmlColorUtils.BLACK)).draw(new ULine(0.0, d));
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(this, stringBounder).getDimension();
    }

    public Instruction getCurrent() {
        return this.currentInstruction;
    }

    public void setCurrent(Instruction instruction) {
        this.currentInstruction = instruction;
    }

    public LinkRendering nextLinkRenderer() {
        return this.nextLinkRenderer;
    }

    public void setNextLinkRenderer(LinkRendering linkRendering) {
        this.nextLinkRenderer = linkRendering;
    }

    public Swimlane getCurrentSwimlane() {
        return this.currentSwimlane;
    }

    class Cross
    extends UGraphicDelegator {
        private Cross(UGraphic uGraphic) {
            super(uGraphic);
        }

        public void draw(UShape uShape) {
            if (uShape instanceof Ftile) {
                Ftile ftile = (Ftile)uShape;
                ftile.drawU(this);
            } else if (uShape instanceof Connection) {
                Swimlane swimlane;
                Connection connection = (Connection)uShape;
                Ftile ftile = connection.getFtile1();
                Ftile ftile2 = connection.getFtile2();
                if (ftile == null || ftile2 == null) {
                    return;
                }
                Swimlane swimlane2 = ftile.getSwimlaneOut();
                if (swimlane2 != (swimlane = ftile2.getSwimlaneIn())) {
                    ConnectionCross connectionCross = new ConnectionCross(connection);
                    connectionCross.drawU(this.getUg());
                }
            }
        }

        public UGraphic apply(UChange uChange) {
            return new Cross(this.getUg().apply(uChange));
        }
    }
}

