# 1.5. Setup Erlang Environment

First we need to install Erlang. There is multiple way, for development we will be using asdf.

## 1.5.1. Setup Erlang using asdf

First, install any missing dependencies:

    sudo apt install curl git autoconf libncurses-dev build-essential m4 libssl-dev 

Download asdf:

    git clone https://github.com/asdf-vm/asdf.git ~/.asdf --branch v0.10.2

Make asdf activate on login by adding these lines at the end of the `~/.bashrc` file:

    . $HOME/.asdf/asdf.sh
    . $HOME/.asdf/completions/asdf.bash

Logout and log back in to activate asdf.

Install asdf plugin for Erlang:

    asdf plugin add erlang https://github.com/asdf-vm/asdf-erlang.git

Install Erlang:

    asdf install erlang 24.3.4.2

Activate Erlang locally for TFS controller:

    cd tfs-ctrl/
    asdf local erlang 24.3.4.2

Install rebar3:

    cd ~
    git clone https://github.com/erlang/rebar3.git
    cd rebar3
    asdf local erlang 24.3.4.2
    ./bootstrap
    ./rebar3 local install

Update `~/.bashrc` to use rebar3 by adding this line at the end:

    export PATH=$HOME/.cache/rebar3/bin:$PATH

Logout and log back in.
