#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

IMAGE_NAME="asgamb1/oc23bgp.img:latest"
DOCKER_CONTAINER=$1
DOCKER_PORT="2022"

sudo docker stop na1 -t 1
sudo docker stop na2 -t 1
sudo docker stop na3 -t 1
sudo docker stop na4 -t 1

sudo docker rm na2
sudo docker rm na1
sudo docker rm na3
sudo docker rm na4

echo "Creating Transponder Agents"

# if ! docker image inspect "$IMAGE_NAME" >/dev/null 2>&1 ; then
#    echo "asgamb1/oc23bgp.img:latest not existed ! "
#    screen -dmS t3 -T xterm sh -c "docker run -p 10.0.2.15:2025:2022 -v ~/tempOC/files:/files --name na -it  $IMAGE_NAME bash"
#    echo 'start downloading  asgamb1/oc23bgp.img:latest , it may take few minutes ! .... ' 
#    while [ "$(docker image inspect asgamb1/oc23bgp.img:latest 2>/dev/null)" == "[]" ]; do
#         sleep 1
# done

#fi



screen -dmS t1 -T xterm sh -c "docker run  -p 127.0.0.1:2023:2022 -v ~/tempOC/files:/files --name $DOCKER_CONTAINER -it asgamb1/oc23bgp.img:latest bash"
sleep  2 
if [ "$( docker container  inspect -f '{{.State.Running}}' "$DOCKER_CONTAINER")" = "true" ]; then 
        docker exec  "$DOCKER_CONTAINER"  cp /files/demoECOC21_4.xml demoECOC21.xml
        docker exec "$DOCKER_CONTAINER" /confd/examples.confd/OC23/startNetconfAgent.sh 
else 
        echo "your container is not running yet"
fi

echo " It may take a while , Hang on ..."
source "./startExtraNetConfigAgent.sh"  "na1" "2023"
sleep 3

source "./startExtraNetConfigAgent.sh"  "na2" "2024"
sleep 3

bash -c "cp /tempOC/files/plat_r1.xml /confd/examples.confd/OC23/init_openconfig-platform.xml; ./startNetconfAgent.sh"
bash -c "cp /tempOC/files/plat_r2.xml /confd/examples.confd/OC23/init_openconfig-platform.xml; ./startNetconfAgent.sh"
screen -dmS t3 -T xterm sh -c 'docker run -p 10.0.2.15:2025:2022 -v ~/tfs-ctrl/tempOC/files:/files --name na3 -it asgamb1/flexscale-node.img:latest ./startNetconfAgent.sh'
screen -dmS t4 -T xterm sh -c 'docker run -p 10.0.2.15:2026:2022 -v ~/tfs-ctrl/tempOC/files:/files --name na4 -it asgamb1/flexscale-node.img:latest ./startNetconfAgent.sh'
