# 1.3. Deploy TeraFlowSDN over MicroK8s

This section describes how to deploy TeraFlowSDN controller on top of MicroK8s using the environment configured in the
previous sections.


## 1.3.1. Install prerequisites
```bash
sudo apt-get install -y git curl jq
```


## 1.3.2. Clone the Git repository of the TeraFlowSDN controller
__Important__: Right now, we have two repositories hosting the code of TeraFlowSDN: GitLab.com and ETSI owned GitLab
               repository. Nowadays, only GitLab.com repository accepts code contributions that are periodically
               mirrored to ETSI labs. In the near future, we plan to swap the repository roles and new contributions
               will be accepted only at ETSI labs, while GitLab.com will probably be kept as a mirror of ETSI. If you
               plan to contribute code to the TeraFlowSDN controller, by now, clone from GitLab.com. We will update the
               tutorial as soon as roles of repositories are swapped.

Clone from GitLab (if you want to contribute code to TeraFlowSDN):
```bash
mkdir ~/tfs-ctrl
git clone https://gitlab.com/teraflow-h2020/controller.git ~/tfs-ctrl
```

Clone from ETSI owned GitLab (if you do not plan to contribute code):
```bash
mkdir ~/tfs-ctrl
git clone https://labs.etsi.org/rep/tfs/controller.git ~/tfs-ctrl
```


## 1.3.3. Checkout the appropriate Git branch
By default 'master' branch is checked out. If you want to deploy 'develop' that incorporates the most up-to-date code
contributions and features, run the following command:
```bash
cd ~/tfs-ctrl
git checkout develop
```

__Important__: During the elaboration and validation of the tutorials, you should checkout branch
               "feat/microk8s-deployment". Otherwise, you will not have important files such as "my_deploy.sh" or
               "deploy.sh". As soon as the tutorials are completed and approved, we will remove this note and merge the
               "feat/microk8s-deployment" into "develop" and later into "master", and then the previous step will be
               effective.


## 1.3.4. Prepare a deployment script with the deployment settings
Create a new deployment script, e.g., `my_deploy.sh`, adding the appropriate settings as follows. This script, by
default, makes use of the private Docker registry enabled in MicroK8s, as specified in `TFS_REGISTRY_IMAGE`. It builds
the Docker images for the subset of components defined in `TFS_COMPONENTS`, tags them with the tag defined in
`TFS_IMAGE_TAG`, deploys them in the namespace defined in `TFS_K8S_NAMESPACE`, and (optionally) deploys the extra
Kubernetes manifests listed in `TFS_EXTRA_MANIFESTS`. Besides, it lets you specify in `TFS_GRAFANA_PASSWORD` the
password to be set for the Grafana `admin` user.

```bash
cd ~/tfs-ctrl
tee my_deploy.sh >/dev/null <<EOF
export TFS_REGISTRY_IMAGE="http://localhost:32000/tfs/"
export TFS_COMPONENTS="context device automation service compute monitoring webui"
export TFS_IMAGE_TAG="dev"
export TFS_K8S_NAMESPACE="tfs"
export TFS_EXTRA_MANIFESTS="manifests/nginx_ingress_http.yaml"
export TFS_GRAFANA_PASSWORD="admin123+"
EOF
```


## 1.3.5. Deploy TFS controller
First, source the deployment settings defined in the previous section. This way, you do not need to specify the
environment variables in each and every command you execute to operate the TFS controller. Be aware to re-source the
file if you open new terminal sessions.
Then, run the following command to deploy TeraFlowSDN controller on top of the MicroK8s Kubernetes platform.

```bash
cd ~/tfs-ctrl
source my_deploy.sh
./deploy.sh
```

The script does the following steps:
1. Build the Docker images for the components defined in `TFS_COMPONENTS`
2. Tag the Docker images with the value of `TFS_IMAGE_TAG`
3. Push the Docker images to the repository defined in `TFS_REGISTRY_IMAGE`
4. Create the namespace defined in `TFS_K8S_NAMESPACE`
5. Deploy the components defined in `TFS_COMPONENTS`
6. Create the file `tfs_runtime_env_vars.sh` with the environment variables for the components defined in
   `TFS_COMPONENTS` defining their local host addresses and their port numbers.
7. Create an ingress controller listening at port 80 for HTTP connections to enable external access to the TeraFlowSDN
   WebUI, Grafana Dashboards, Context Debug endpoints, and Compute NBI interfaces.
8. Initialize and configure the Grafana dashboards
9. Report a summary of the deployment (see 
   [1.5. Show Deployment and Log per Component](./1-5-deploy-logs-troubleshooting.md))
