#!/bin/bash
# Copyright 2022-2024 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.


kubectl delete namespace tfs-e2e tfs-ip

echo "Deploying tfs-e2e ..."
kubectl delete -f src/tests/ecoc24/nginx-ingress-controller-e2e.yaml                > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl create namespace tfs-e2e                                                    > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl apply -f src/tests/ecoc24/nginx-ingress-controller-e2e.yaml                 > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/contextservice.yaml            > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/deviceservice.yaml             > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/e2e_orchestratorservice.yaml    > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/pathcompservice.yaml           > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/serviceservice.yaml            > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/sliceservice.yaml              > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f ./tmp/tfs-e2e/manifests/webuiservice.yaml              > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
kubectl --namespace tfs-e2e apply -f src/tests/ecoc24/tfs-ingress-e2e.yaml                    > ./tmp/tfs-e2e/logs/deploy-tfs-e2e.log
printf "\n"

echo "Deploying tfs-ip ..."
kubectl delete -f src/tests/ecoc24/nginx-ingress-controller-ip.yaml                 > ./tmp/logs/deploy-tfs-ip.log
kubectl create namespace tfs-ip                                                     > ./tmp/logs/deploy-tfs-ip.log
kubectl apply -f src/tests/ecoc24/nginx-ingress-controller-ip.yaml                  > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/contextservice.yaml             > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/deviceservice.yaml              > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/pathcompservice.yaml            > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/serviceservice.yaml             > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/sliceservice.yaml               > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/vnt_managerservice.yaml          > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f ./tmp/tfs-ip/manifests/webuiservice.yaml               > ./tmp/logs/deploy-tfs-ip.log
kubectl --namespace tfs-ip apply -f src/tests/ecoc24/tfs-ingress-ip.yaml                      > ./tmp/logs/deploy-tfs-ip.log
printf "\n"

echo "Waiting tfs-e2e ..."
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/contextservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/deviceservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/e2e-orchestratorservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/pathcompservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/serviceservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/sliceservice
kubectl wait --namespace tfs-e2e --for='condition=available' --timeout=300s deployment/webuiservice
printf "\n"

echo "Waiting tfs-ip ..."
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/contextservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/deviceservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/pathcompservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/serviceservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/sliceservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/vnt-managerservice
kubectl wait --namespace tfs-ip --for='condition=available' --timeout=300s deployment/webuiservice
printf "\n"

echo "Done!"
