# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

import json, logging
from typing import Any, Dict, List, Tuple
from ._Handler import _Handler

LOGGER = logging.getLogger(__name__)

class NetworkInstanceInterfaceHandler(_Handler):
    def get_resource_key(self) -> str: return '/network_instance/interface'
    def get_path(self) -> str: return '/network-instances/network-instance/interfaces'

    def compose(self, resource_key : str, resource_value : Dict, delete : bool = False) -> Tuple[str, str]:
        ni_name   = str(resource_value['name'     ])    # test-svc
        if_name   = str(resource_value['if_name'  ])    # ethernet-1/1
        sif_index = int(resource_value['sif_index'])    # 0
        if_id     = '{:s}.{:d}'.format(if_name, sif_index)

        if delete:
            PATH_TMPL = '/network-instances/network-instance[name={:s}]/interfaces/interface[id={:s}]'
            str_path = PATH_TMPL.format(ni_name, if_id)
            str_data = json.dumps({})
            return str_path, str_data

        str_path = '/network-instances/network-instance[name={:s}]/interfaces/interface[id={:s}]'.format(ni_name, if_id)
        str_data = json.dumps({
            'id': if_id,
            'config': {'id': if_id, 'interface': if_name, 'subinterface': sif_index},
        })
        return str_path, str_data

    def parse(self, json_data : Dict) -> List[Tuple[str, Dict[str, Any]]]:
        response = []
        return response
