/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.real.RealUtils;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class NoteTile
implements Tile {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Note note;

    public NoteTile(LivingSpace livingSpace, LivingSpace livingSpace2, Note note, Skin skin, ISkinParam iSkinParam) {
        this.livingSpace1 = livingSpace;
        this.livingSpace2 = livingSpace2;
        this.note = note;
        this.skin = skin;
        this.skinParam = iSkinParam;
    }

    private Component getComponent(StringBounder stringBounder) {
        Component component = this.skin.createComponent(ComponentType.NOTE, null, this.skinParam, this.note.getStrings());
        return component;
    }

    public void drawU(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getX(stringBounder).getCurrentValue();
        Area area = new Area(this.getUsedWidth(stringBounder), dimension2D.getHeight());
        uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }

    private double getUsedWidth(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        if (this.note.getPosition() == NotePosition.OVER_SEVERAL) {
            double d2 = this.livingSpace1.getPosB().getCurrentValue();
            double d3 = this.livingSpace2.getPosD(stringBounder).getCurrentValue();
            double d4 = d3 - d2;
            if (d < d4) {
                return d4;
            }
        }
        return d;
    }

    private Real getX(StringBounder stringBounder) {
        NotePosition notePosition = this.note.getPosition();
        double d = this.getUsedWidth(stringBounder);
        if (notePosition == NotePosition.LEFT) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-d);
        }
        if (notePosition == NotePosition.RIGHT) {
            return this.livingSpace1.getPosC(stringBounder);
        }
        if (notePosition == NotePosition.OVER_SEVERAL) {
            Real real = this.livingSpace1.getPosC(stringBounder);
            Real real2 = this.livingSpace2.getPosC(stringBounder);
            return RealUtils.middle(real, real2).addFixed(-d / 2.0);
        }
        if (notePosition == NotePosition.OVER) {
            return this.livingSpace1.getPosC(stringBounder).addFixed(-d / 2.0);
        }
        throw new UnsupportedOperationException(notePosition.toString());
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D.getHeight();
    }

    public void addConstraints(StringBounder stringBounder) {
    }

    public Real getMinX(StringBounder stringBounder) {
        return this.getX(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        return this.getX(stringBounder).addFixed(this.getUsedWidth(stringBounder));
    }
}

