# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class otn_ltp(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/termination-point/te/otn-ltp. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Attributes of the OTN Link Termination Point (LTP).
  """
  __slots__ = ('_path_helper', '_extmethods', '__odtu_flex_type',)

  _yang_name = 'otn-ltp'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__odtu_flex_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'termination-point', 'te', 'otn-ltp']

  def _get_odtu_flex_type(self):
    """
    Getter method for odtu_flex_type, mapped from YANG variable /networks/network/node/termination_point/te/otn_ltp/odtu_flex_type (l1-types:odtu-flex-type)

    YANG Description: The type of Optical Data Tributary Unit (ODTU)
whose nominal bitrate is used to compute the number of
Tributary Slots (TS) required by the ODUflex LSPs set up
on this OTN Link Termination Point (LTP).
    """
    return self.__odtu_flex_type
      
  def _set_odtu_flex_type(self, v, load=False):
    """
    Setter method for odtu_flex_type, mapped from YANG variable /networks/network/node/termination_point/te/otn_ltp/odtu_flex_type (l1-types:odtu-flex-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_odtu_flex_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_odtu_flex_type() directly.

    YANG Description: The type of Optical Data Tributary Unit (ODTU)
whose nominal bitrate is used to compute the number of
Tributary Slots (TS) required by the ODUflex LSPs set up
on this OTN Link Termination Point (LTP).
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """odtu_flex_type must be of a type compatible with l1-types:odtu-flex-type""",
          'defined-type': "l1-types:odtu-flex-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)""",
        })

    self.__odtu_flex_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_odtu_flex_type(self):
    self.__odtu_flex_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'2': {}, '3': {}, '4': {}, 'Cn': {}},), is_leaf=True, yang_name="odtu-flex-type", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-otn-topology', defining_module='ietf-otn-topology', yang_type='l1-types:odtu-flex-type', is_config=True)

  odtu_flex_type = __builtin__.property(_get_odtu_flex_type, _set_odtu_flex_type)


  _pyangbind_elements = OrderedDict([('odtu_flex_type', odtu_flex_type), ])


