#!/bin/bash
# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

component=$1

source "my_deploy.sh"

echo "Deploying $component..."

# check if component == "CAD"
if [ $component == "CAD" ]; then
    # find kubernetes pod that contains "centralizedattackdetectorservice"
    pod=$(kubectl --namespace $TFS_K8S_NAMESPACE get pods | grep l3-centralizedattackdetectorservice | awk '{print $1}')
    
    # delete pod
    kubectl --namespace $TFS_K8S_NAMESPACE delete pod $pod --force --grace-period=0
    
    # # wait for pod to be deleted
    # while [ $(kubectl --namespace $TFS_K8S_NAMESPACE get pods | grep l3-centralizedattackdetectorservice | wc -l) -gt 0 ]; do
    #     sleep 1
    # done
    
    # deploy l3_centralizedattackdetector component
    ./deploy_component.sh "l3_centralizedattackdetector"
fi

# check if component == "AM"
if [ $component == "AM" ]; then
    # find kubernetes pod that contains "l3-attackmitigatorservice"
    pod=$(kubectl --namespace $TFS_K8S_NAMESPACE get pods | grep l3-attackmitigatorservice | awk '{print $1}')
    
    # delete pod
    kubectl --namespace $TFS_K8S_NAMESPACE delete pod $pod --force --grace-period=0
    
    # # wait for pod to be deleted
    # while [ $(kubectl --namespace $TFS_K8S_NAMESPACE get pods | grep l3-attackmitigatorservice | wc -l) -gt 0 ]; do
    #     sleep 1
    # done
    
    # deploy l3_attackmitigator component
    ./deploy_component.sh "l3_attackmitigator"
fi

echo "Component $component deployed"

echo "Restarting DAD..."
sshpass -p "ubuntu" ssh -o StrictHostKeyChecking=no -n -f ubuntu@192.168.165.73 "sh -c 'nohup /home/ubuntu/TeraflowDockerDistributed/restart.sh > /dev/null 2>&1 &'"
echo "DAD restarted"
