from copy import deepcopy
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from context.proto.context_pb2 import (
    DeviceDriverEnum, DeviceOperationalStatusEnum, ServiceStatusEnum, ServiceTypeEnum)
from context.proto.kpi_sample_types_pb2 import KpiSampleType
from .Tools import config_rule_set, endpoint, endpoint_id

# Some example objects to be used by the tests

## use "deepcopy" to prevent propagating forced changes during tests
CONTEXT_ID = {'context_uuid': {'uuid': DEFAULT_CONTEXT_UUID}}
CONTEXT = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_ids': [],
    'service_ids': [],
}

TOPOLOGY_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_uuid': {'uuid': DEFAULT_TOPOLOGY_UUID},
}
TOPOLOGY = {
    'topology_id': deepcopy(TOPOLOGY_ID),
    'device_ids': [],
    'link_ids': [],
}

PACKET_PORT_SAMPLE_TYPES = [
    KpiSampleType.KPISAMPLETYPE_PACKETS_TRANSMITTED,
    KpiSampleType.KPISAMPLETYPE_PACKETS_RECEIVED,
    KpiSampleType.KPISAMPLETYPE_BYTES_TRANSMITTED,
    KpiSampleType.KPISAMPLETYPE_BYTES_RECEIVED,
]

def _endpoint_id(device_id, endpoint_uuid):
    return endpoint_id(device_id, endpoint_uuid, topology_id=TOPOLOGY_ID)

def _endpoint(device_id, endpoint_uuid, endpoint_type):
    return endpoint(
        device_id, endpoint_uuid, endpoint_type, topology_id=TOPOLOGY_ID, kpi_sample_types=PACKET_PORT_SAMPLE_TYPES)

DEVICE1_UUID = 'DEV1'
DEVICE1_ID = {'device_uuid': {'uuid': DEVICE1_UUID}}
DEVICE1 = {
    'device_id': deepcopy(DEVICE1_ID),
    'device_type': 'packet-router',
    'device_config': {'config_rules': [
        config_rule_set('dev/rsrc1/value', 'value1'),
        config_rule_set('dev/rsrc2/value', 'value2'),
        config_rule_set('dev/rsrc3/value', 'value3'),
    ]},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG, DeviceDriverEnum.DEVICEDRIVER_P4],
    'device_endpoints': [
        _endpoint(DEVICE1_ID, 'EP2',   'port-packet-100G'),
        _endpoint(DEVICE1_ID, 'EP3',   'port-packet-100G'),
        _endpoint(DEVICE1_ID, 'EP100', 'port-packet-10G' ),
    ],
}

DEVICE2_UUID = 'DEV2'
DEVICE2_ID = {'device_uuid': {'uuid': DEVICE2_UUID}}
DEVICE2 = {
    'device_id': deepcopy(DEVICE2_ID),
    'device_type': 'packet-router',
    'device_config': {'config_rules': [
        config_rule_set('dev/rsrc1/value', 'value4'),
        config_rule_set('dev/rsrc2/value', 'value5'),
        config_rule_set('dev/rsrc3/value', 'value6'),
    ]},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG, DeviceDriverEnum.DEVICEDRIVER_P4],
    'device_endpoints': [
        _endpoint(DEVICE2_ID, 'EP1',   'port-packet-100G'),
        _endpoint(DEVICE2_ID, 'EP3',   'port-packet-100G'),
        _endpoint(DEVICE2_ID, 'EP100', 'port-packet-10G' ),
    ],
}

DEVICE3_UUID = 'DEV3'
DEVICE3_ID = {'device_uuid': {'uuid': DEVICE3_UUID}}
DEVICE3 = {
    'device_id': deepcopy(DEVICE3_ID),
    'device_type': 'packet-router',
    'device_config': {'config_rules': [
        config_rule_set('dev/rsrc1/value', 'value4'),
        config_rule_set('dev/rsrc2/value', 'value5'),
        config_rule_set('dev/rsrc3/value', 'value6'),
    ]},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG, DeviceDriverEnum.DEVICEDRIVER_P4],
    'device_endpoints': [
        _endpoint(DEVICE3_ID, 'EP1',   'port-packet-100G'),
        _endpoint(DEVICE3_ID, 'EP2',   'port-packet-100G'),
        _endpoint(DEVICE3_ID, 'EP100', 'port-packet-10G' ),
    ],
}

LINK_DEV1_DEV2_UUID = 'DEV1/EP2 ==> DEV2/EP1'
LINK_DEV1_DEV2_ID = {'link_uuid': {'uuid': LINK_DEV1_DEV2_UUID}}
LINK_DEV1_DEV2 = {
    'link_id': deepcopy(LINK_DEV1_DEV2_ID),
    'link_endpoint_ids' : [
        _endpoint_id(DEVICE1_ID, 'EP2'),
        _endpoint_id(DEVICE2_ID, 'EP1'),
    ]
}

LINK_DEV2_DEV3_UUID = 'DEV2/EP3 ==> DEV3/EP2'
LINK_DEV2_DEV3_ID = {'link_uuid': {'uuid': LINK_DEV2_DEV3_UUID}}
LINK_DEV2_DEV3 = {
    'link_id': deepcopy(LINK_DEV2_DEV3_ID),
    'link_endpoint_ids' : [
        _endpoint_id(DEVICE2_ID, 'EP3'),
        _endpoint_id(DEVICE3_ID, 'EP2'),
    ]
}

LINK_DEV1_DEV3_UUID = 'DEV1/EP3 ==> DEV3/EP1'
LINK_DEV1_DEV3_ID = {'link_uuid': {'uuid': LINK_DEV1_DEV3_UUID}}
LINK_DEV1_DEV3 = {
    'link_id': deepcopy(LINK_DEV1_DEV3_ID),
    'link_endpoint_ids' : [
        _endpoint_id(DEVICE1_ID, 'EP3'),
        _endpoint_id(DEVICE3_ID, 'EP1'),
    ]
}

SERVICE_DEV1_DEV2_UUID = 'SVC:DEV1/EP100-DEV2/EP100'
SERVICE_DEV1_DEV2_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'service_uuid': {'uuid': SERVICE_DEV1_DEV2_UUID},
}
SERVICE_DEV1_DEV2 = {
    'service_id': deepcopy(SERVICE_DEV1_DEV2_ID),
    'service_type': ServiceTypeEnum.SERVICETYPE_L3NM,
    'service_endpoint_ids' : [
        _endpoint_id(DEVICE1_ID, 'EP100'),
        _endpoint_id(DEVICE2_ID, 'EP100'),
    ],
    'service_constraints': [
        {'constraint_type': 'latency_ms', 'constraint_value': '15.2'},
        {'constraint_type': 'jitter_us', 'constraint_value': '1.2'},
    ],
    'service_status': {'service_status': ServiceStatusEnum.SERVICESTATUS_ACTIVE},
    'service_config': {'config_rules': [
        config_rule_set('svc/rsrc1/value', 'value7'),
        config_rule_set('svc/rsrc2/value', 'value8'),
        config_rule_set('svc/rsrc3/value', 'value9'),
    ]},
}

SERVICE_DEV1_DEV3_UUID = 'SVC:DEV1/EP100-DEV3/EP100'
SERVICE_DEV1_DEV3_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'service_uuid': {'uuid': SERVICE_DEV1_DEV3_UUID},
}
SERVICE_DEV1_DEV3 = {
    'service_id': deepcopy(SERVICE_DEV1_DEV3_ID),
    'service_type': ServiceTypeEnum.SERVICETYPE_L3NM,
    'service_endpoint_ids' : [
        _endpoint_id(DEVICE1_ID, 'EP100'),
        _endpoint_id(DEVICE3_ID, 'EP100'),
    ],
    'service_constraints': [
        {'constraint_type': 'latency_ms', 'constraint_value': '5.8'},
        {'constraint_type': 'jitter_us', 'constraint_value': '0.1'},
    ],
    'service_status': {'service_status': ServiceStatusEnum.SERVICESTATUS_ACTIVE},
    'service_config': {'config_rules': [
        config_rule_set('svc/rsrc1/value', 'value7'),
        config_rule_set('svc/rsrc2/value', 'value8'),
        config_rule_set('svc/rsrc3/value', 'value9'),
    ]},
}

SERVICE_DEV2_DEV3_UUID = 'SVC:DEV2/EP100-DEV3/EP100'
SERVICE_DEV2_DEV3_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'service_uuid': {'uuid': SERVICE_DEV2_DEV3_UUID},
}
SERVICE_DEV2_DEV3 = {
    'service_id': deepcopy(SERVICE_DEV2_DEV3_ID),
    'service_type': ServiceTypeEnum.SERVICETYPE_L3NM,
    'service_endpoint_ids' : [
        _endpoint_id(DEVICE2_ID, 'EP100'),
        _endpoint_id(DEVICE3_ID, 'EP100'),
    ],
    'service_constraints': [
        {'constraint_type': 'latency_ms', 'constraint_value': '23.1'},
        {'constraint_type': 'jitter_us', 'constraint_value': '3.4'},
    ],
    'service_status': {'service_status': ServiceStatusEnum.SERVICESTATUS_ACTIVE},
    'service_config': {'config_rules': [
        config_rule_set('svc/rsrc1/value', 'value7'),
        config_rule_set('svc/rsrc2/value', 'value8'),
        config_rule_set('svc/rsrc3/value', 'value9'),
    ]},
}

CONNECTION_DEV1_DEV3_UUID = 'CON:DEV1/EP100-DEV3/EP100'
CONNECTION_DEV1_DEV3_ID = {
    'connection_uuid': {'uuid': CONNECTION_DEV1_DEV3_UUID},
}
CONNECTION_DEV1_DEV3 = {
    'connection_id': deepcopy(CONNECTION_DEV1_DEV3_ID),
    'service_id': deepcopy(SERVICE_DEV1_DEV3_ID),
    'path_hops_endpoint_ids' : [
        _endpoint_id(DEVICE1_ID, 'EP100'),
        _endpoint_id(DEVICE1_ID, 'EP2'),
        _endpoint_id(DEVICE2_ID, 'EP1'),
        _endpoint_id(DEVICE2_ID, 'EP3'),
        _endpoint_id(DEVICE3_ID, 'EP2'),
        _endpoint_id(DEVICE3_ID, 'EP100'),
    ],
    'sub_service_ids': [
        deepcopy(SERVICE_DEV1_DEV2_ID),
        deepcopy(SERVICE_DEV2_DEV3_ID),
    ],
}
