import logging
from common.orm.fields.ForeignKeyField import ForeignKeyField
from common.orm.fields.PrimaryKeyField import PrimaryKeyField
from common.orm.model.Model import Model
from .ConnectionModel import ConnectionModel
from .DeviceModel import DeviceModel
from .EndPointModel import EndPointModel
from .LinkModel import LinkModel
from .ServiceModel import ServiceModel
from .TopologyModel import TopologyModel

LOGGER = logging.getLogger(__name__)

class ConnectionSubServiceModel(Model): # pylint: disable=abstract-method
    pk = PrimaryKeyField()
    connection_fk = ForeignKeyField(ConnectionModel)
    sub_service_fk = ForeignKeyField(ServiceModel)

class LinkEndPointModel(Model): # pylint: disable=abstract-method
    pk = PrimaryKeyField()
    link_fk = ForeignKeyField(LinkModel)
    endpoint_fk = ForeignKeyField(EndPointModel)

class ServiceEndPointModel(Model): # pylint: disable=abstract-method
    pk = PrimaryKeyField()
    service_fk = ForeignKeyField(ServiceModel)
    endpoint_fk = ForeignKeyField(EndPointModel)

class TopologyDeviceModel(Model): # pylint: disable=abstract-method
    pk = PrimaryKeyField()
    topology_fk = ForeignKeyField(TopologyModel)
    device_fk = ForeignKeyField(DeviceModel)

class TopologyLinkModel(Model): # pylint: disable=abstract-method
    pk = PrimaryKeyField()
    topology_fk = ForeignKeyField(TopologyModel)
    link_fk = ForeignKeyField(LinkModel)
