package eu.teraflow.automation.device;

import eu.teraflow.automation.device.model.DeviceConfig;
import eu.teraflow.automation.device.model.DeviceId;
import eu.teraflow.automation.device.model.DeviceOperationalStatus;
import eu.teraflow.automation.device.model.DeviceType;

public class Device {

    private final DeviceId deviceId;
    private final DeviceType deviceType;
    private DeviceConfig deviceConfig;
    private DeviceOperationalStatus deviceOperationalStatus;

    public Device(
            DeviceId deviceId,
            DeviceType deviceType,
            DeviceConfig deviceConfig,
            DeviceOperationalStatus deviceOperationalStatus) {

        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.deviceConfig = deviceConfig;
        this.deviceOperationalStatus = deviceOperationalStatus;
    }

    public Device(
            DeviceId deviceId, DeviceType deviceType, DeviceOperationalStatus deviceOperationalStatus) {

        this.deviceId = deviceId;
        this.deviceType = deviceType;
        this.deviceOperationalStatus = deviceOperationalStatus;
    }

    public DeviceId getDeviceId() {
        return deviceId;
    }

    public DeviceType getDeviceType() {
        return deviceType;
    }

    public DeviceConfig getDeviceConfig() {
        return deviceConfig;
    }

    public DeviceOperationalStatus getDeviceOperationalStatus() {
        return deviceOperationalStatus;
    }

    public void setDeviceOperationalStatus(DeviceOperationalStatus status) {

        this.deviceOperationalStatus = status;
    }

    public void setDeviceConfiguration(DeviceConfig deviceConfig) {

        this.deviceConfig = deviceConfig;
    }

    public boolean isConfigured() {

        return this.deviceOperationalStatus == DeviceOperationalStatus.ENABLED;
    }
}
