from wtforms.validators import ValidationError

def key_value_validator():
    def _validate(form, field):
        if len(field.data) > 0:
            if '\n' not in field.data:  # case in which there is only one configuration
                if '=' not in field.data:
                    raise ValidationError(f'Configuration "{field.data}" does not follow the key=value pattern.')
            else:  # case in which there are several configurations
                configurations = field.data.split('\n')
                for configutation in configurations:
                    if '=' not in configutation:
                        raise ValidationError(f'Configuration "{configutation}" does not follow the key=value pattern.')
    return _validate
