#!/bin/bash

PROJECTDIR=`pwd`

cd $PROJECTDIR/src
RCFILE=$PROJECTDIR/coverage/.coveragerc
COVERAGEFILE=$PROJECTDIR/coverage/.coverage

# configure the correct folder on the .coveragerc file
cat $PROJECTDIR/coverage/.coveragerc.template | sed s+~/teraflow/controller+$PROJECTDIR+g > $RCFILE

# Run unitary tests and analyze coverage of code at same time

# Populate environment variables for context to use Redis in a development machine running Kubernetes
# Uncomment below lines to create a Redis instance within Context for testing purposes.
#kubectl delete namespace tf-dev
#kubectl create namespace tf-dev
#kubectl --namespace tf-dev apply -f ../manifests/contextservice.yaml
#kubectl --namespace tf-dev expose deployment contextservice --port=6379 --type=NodePort --name=redis-tests
#echo "Waiting 10 seconds for Redis to start..."
#sleep 10
export REDIS_SERVICE_HOST=$(kubectl get node kubernetes-master -o 'jsonpath={.status.addresses[?(@.type=="InternalIP")].address}')
export REDIS_SERVICE_PORT=$(kubectl get service redis-tests --namespace tf-dev -o 'jsonpath={.spec.ports[?(@.port==6379)].nodePort}')

# First destroy old coverage file
rm -f $COVERAGEFILE

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    common/orm/tests/test_unitary.py \
    common/message_broker/tests/test_unitary.py \
    common/rpc_method_wrapper/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    context/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    device/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest -s --log-level=INFO --verbose \
    l3_centralizedattackdetector/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest -s --log-level=INFO --verbose \
    l3_distributedattackdetector/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest -s --log-level=INFO --verbose \
    l3_attackmitigator/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    opticalcentralizedattackdetector/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    dbscanserving/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    opticalattackmitigator/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    service/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    compute/tests/test_unitary.py

coverage run --rcfile=$RCFILE --append -m pytest --log-level=INFO --verbose \
    webui/tests/test_unitary.py
