/**
 * Copyright 2022-2024 ETSI SDG TeraFlowSDN (TFS) (https://tfs.etsi.org/)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * Build script that generates Rust code for the protobuffers.
 *
 * Author: Carlos Natalino <carlos.natalino@chalmers.se>
 */

fn main() {
    tonic_build::configure()
        .build_server(false)
        .compile(
            &[
                "proto/context.proto",
                "proto/acl.proto",
                "proto/kpi_sample_types.proto",
                "proto/monitoring.proto",
            ],
            &["proto"],
        )
        .unwrap_or_else(|e| panic!("Failed to compile protos {:?}", e));
}
