#!/bin/bash
# Copyright 2021-2023 H2020 TeraFlow (https://www.teraflow-h2020.eu/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

export COMPONENT="webui"
export IMAGE_TAG="ofc22"
export K8S_NAMESPACE="ofc22"
export K8S_HOSTNAME="kubernetes-master"
export GRAFANA_PASSWORD="admin123+"

# Constants
TMP_FOLDER="./tmp"

# Create a tmp folder for files modified during the deployment
TMP_MANIFESTS_FOLDER="$TMP_FOLDER/manifests"
mkdir -p $TMP_MANIFESTS_FOLDER
TMP_LOGS_FOLDER="$TMP_FOLDER/logs"
mkdir -p $TMP_LOGS_FOLDER

echo "Processing '$COMPONENT' component..."
IMAGE_NAME="$COMPONENT:$IMAGE_TAG"

echo "  Building Docker image..."
BUILD_LOG="$TMP_LOGS_FOLDER/build_${COMPONENT}.log"
docker build -t "$IMAGE_NAME" -f ./src/"$COMPONENT"/Dockerfile ./src/ > "$BUILD_LOG"

sleep 1

echo "  Deploying '$COMPONENT' component to Kubernetes..."
kubectl --namespace $K8S_NAMESPACE scale deployment --replicas=0 ${COMPONENT}service
kubectl --namespace $K8S_NAMESPACE scale deployment --replicas=1 ${COMPONENT}service
printf "\n"

sleep 1

echo "Waiting for '$COMPONENT' component..."
kubectl wait --namespace $K8S_NAMESPACE --for='condition=available' --timeout=300s deployment/${COMPONENT}service
printf "\n"

echo "Configuring DataStores and Dashboards..."
./configure_dashboards.sh
printf "\n\n"

echo "Reporting Deployment..."
kubectl --namespace $K8S_NAMESPACE get all
printf "\n"

echo "Done!"
