# Copyright 2022-2023 ETSI TeraFlowSDN - TFS OSG (https://tfs.etsi.org/)
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from flask_wtf import FlaskForm
from wtforms import BooleanField, FloatField, IntegerField, StringField, SubmitField
from wtforms.validators import DataRequired, NumberRange

class LoadGenForm(FlaskForm):
    num_requests = IntegerField('Num Requests', default=100, validators=[DataRequired(), NumberRange(min=0)])
    num_generated = IntegerField('Num Generated', default=0, render_kw={'readonly': True})

    request_type_service_l2nm = BooleanField('Service L2NM', default=False)
    request_type_service_l3nm = BooleanField('Service L3NM', default=False)
    request_type_service_mw = BooleanField('Service MW', default=False)
    request_type_service_tapi = BooleanField('Service TAPI', default=False)
    request_type_slice_l2nm = BooleanField('Slice L2NM', default=True)
    request_type_slice_l3nm = BooleanField('Slice L3NM', default=False)

    offered_load = FloatField('Offered Load [Erlang]', default=50, validators=[NumberRange(min=0.0)])
    holding_time = FloatField('Holding Time [seconds]', default=10, validators=[NumberRange(min=0.0)])
    inter_arrival_time = FloatField('Inter Arrival Time [seconds]', default=0, validators=[NumberRange(min=0.0)])

    do_teardown = BooleanField('Do Teardown', default=True)

    record_to_dlt = BooleanField('Record to DLT', default=False)
    dlt_domain_id = StringField('DLT Domain Id', default='')

    infinite_loop = BooleanField('Infinite Loop', default=False, render_kw={'disabled': True})
    running = BooleanField('Running', default=False, render_kw={'disabled': True})

    submit = SubmitField('Start/Stop')
