/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.hector;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.plantuml.hector.Pin;
import net.sourceforge.plantuml.hector.PinLink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Skeleton {
    private final List<Pin> pins;
    private final List<PinLink> pinLinks;
    private final SortedSet<Integer> rows = new TreeSet<Integer>();

    public Skeleton(List<Pin> list, List<PinLink> list2) {
        this.pins = list;
        this.pinLinks = list2;
        int n = 0;
        for (Pin pin : list) {
            pin.setUid(n++);
            this.rows.add(pin.getRow());
        }
    }

    public SortedSet<Integer> getRows() {
        return this.rows;
    }

    public List<Pin> getPins() {
        return this.pins;
    }

    public Collection<Pin> getPinsOfRow(int n) {
        LinkedHashSet<Pin> linkedHashSet = new LinkedHashSet<Pin>();
        for (Pin pin : this.pins) {
            if (pin.getRow() != n) continue;
            linkedHashSet.add(pin);
        }
        return linkedHashSet;
    }

    public List<PinLink> getPinLinks() {
        return this.pinLinks;
    }
}

