# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

from . import information_source_state
from . import connectivity_matrices
from . import underlay_topology
class information_source_entry(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/information-source-entry. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: A list of information sources learned, including the source
that is used.
  """
  __slots__ = ('_path_helper', '_extmethods', '__information_source','__information_source_instance','__information_source_state','__connectivity_matrices','__domain_id','__is_abstract','__name','__signaling_address','__underlay_topology',)

  _yang_name = 'information-source-entry'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__information_source = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)
    self.__information_source_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    self.__information_source_state = YANGDynClass(base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__connectivity_matrices = YANGDynClass(base=connectivity_matrices.connectivity_matrices, is_container='container', yang_name="connectivity-matrices", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    self.__domain_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="domain-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)
    self.__is_abstract = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    self.__signaling_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="signaling-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:ip-address', is_config=False)
    self.__underlay_topology = YANGDynClass(base=underlay_topology.underlay_topology, is_container='container', yang_name="underlay-topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'information-source-entry']

  def _get_information_source(self):
    """
    Getter method for information_source, mapped from YANG variable /networks/network/node/te/information_source_entry/information_source (te-info-source)

    YANG Description: Indicates the type of information source.
    """
    return self.__information_source
      
  def _set_information_source(self, v, load=False):
    """
    Setter method for information_source, mapped from YANG variable /networks/network/node/te/information_source_entry/information_source (te-info-source)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source() directly.

    YANG Description: Indicates the type of information source.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source must be of a type compatible with te-info-source""",
          'defined-type': "ietf-te-topology:te-info-source",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)""",
        })

    self.__information_source = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source(self):
    self.__information_source = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'unknown': {}, 'locally-configured': {}, 'ospfv2': {}, 'ospfv3': {}, 'isis': {}, 'bgp-ls': {}, 'system-processed': {}, 'other': {}},), is_leaf=True, yang_name="information-source", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-info-source', is_config=False)


  def _get_information_source_instance(self):
    """
    Getter method for information_source_instance, mapped from YANG variable /networks/network/node/te/information_source_entry/information_source_instance (string)

    YANG Description: The name indicating the instance of the information
source.
    """
    return self.__information_source_instance
      
  def _set_information_source_instance(self, v, load=False):
    """
    Setter method for information_source_instance, mapped from YANG variable /networks/network/node/te/information_source_entry/information_source_instance (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source_instance is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source_instance() directly.

    YANG Description: The name indicating the instance of the information
source.
    """
    parent = getattr(self, "_parent", None)
    if parent is not None and load is False:
      raise AttributeError("Cannot set keys directly when" +
                             " within an instantiated list")

    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source_instance must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)""",
        })

    self.__information_source_instance = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source_instance(self):
    self.__information_source_instance = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="information-source-instance", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, is_keyval=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)


  def _get_information_source_state(self):
    """
    Getter method for information_source_state, mapped from YANG variable /networks/network/node/te/information_source_entry/information_source_state (container)

    YANG Description: Contains state attributes related to the information
source.
    """
    return self.__information_source_state
      
  def _set_information_source_state(self, v, load=False):
    """
    Setter method for information_source_state, mapped from YANG variable /networks/network/node/te/information_source_entry/information_source_state (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_information_source_state is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_information_source_state() directly.

    YANG Description: Contains state attributes related to the information
source.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """information_source_state must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__information_source_state = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_information_source_state(self):
    self.__information_source_state = YANGDynClass(base=information_source_state.information_source_state, is_container='container', yang_name="information-source-state", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_connectivity_matrices(self):
    """
    Getter method for connectivity_matrices, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices (container)

    YANG Description: Contains a connectivity matrix on a TE node.
    """
    return self.__connectivity_matrices
      
  def _set_connectivity_matrices(self, v, load=False):
    """
    Setter method for connectivity_matrices, mapped from YANG variable /networks/network/node/te/information_source_entry/connectivity_matrices (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_connectivity_matrices is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_connectivity_matrices() directly.

    YANG Description: Contains a connectivity matrix on a TE node.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=connectivity_matrices.connectivity_matrices, is_container='container', yang_name="connectivity-matrices", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """connectivity_matrices must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=connectivity_matrices.connectivity_matrices, is_container='container', yang_name="connectivity-matrices", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__connectivity_matrices = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_connectivity_matrices(self):
    self.__connectivity_matrices = YANGDynClass(base=connectivity_matrices.connectivity_matrices, is_container='container', yang_name="connectivity-matrices", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)


  def _get_domain_id(self):
    """
    Getter method for domain_id, mapped from YANG variable /networks/network/node/te/information_source_entry/domain_id (uint32)

    YANG Description: Identifies the domain to which this node belongs.
This attribute is used to support inter-domain links.
    """
    return self.__domain_id
      
  def _set_domain_id(self, v, load=False):
    """
    Setter method for domain_id, mapped from YANG variable /networks/network/node/te/information_source_entry/domain_id (uint32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_domain_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_domain_id() directly.

    YANG Description: Identifies the domain to which this node belongs.
This attribute is used to support inter-domain links.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="domain-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """domain_id must be of a type compatible with uint32""",
          'defined-type': "uint32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="domain-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)""",
        })

    self.__domain_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_domain_id(self):
    self.__domain_id = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="domain-id", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='uint32', is_config=False)


  def _get_is_abstract(self):
    """
    Getter method for is_abstract, mapped from YANG variable /networks/network/node/te/information_source_entry/is_abstract (empty)

    YANG Description: Present if the node is abstract; not present if the node
is actual.
    """
    return self.__is_abstract
      
  def _set_is_abstract(self, v, load=False):
    """
    Setter method for is_abstract, mapped from YANG variable /networks/network/node/te/information_source_entry/is_abstract (empty)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_is_abstract is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_is_abstract() directly.

    YANG Description: Present if the node is abstract; not present if the node
is actual.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """is_abstract must be of a type compatible with empty""",
          'defined-type': "empty",
          'generated-type': """YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)""",
        })

    self.__is_abstract = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_is_abstract(self):
    self.__is_abstract = YANGDynClass(base=YANGBool, is_leaf=True, yang_name="is-abstract", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='empty', is_config=False)


  def _get_name(self):
    """
    Getter method for name, mapped from YANG variable /networks/network/node/te/information_source_entry/name (string)

    YANG Description: Node name.
    """
    return self.__name
      
  def _set_name(self, v, load=False):
    """
    Setter method for name, mapped from YANG variable /networks/network/node/te/information_source_entry/name (string)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_name is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_name() directly.

    YANG Description: Node name.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """name must be of a type compatible with string""",
          'defined-type': "string",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)""",
        })

    self.__name = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_name(self):
    self.__name = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="name", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='string', is_config=False)


  def _get_signaling_address(self):
    """
    Getter method for signaling_address, mapped from YANG variable /networks/network/node/te/information_source_entry/signaling_address (inet:ip-address)

    YANG Description: The node's signaling address.
    """
    return self.__signaling_address
      
  def _set_signaling_address(self, v, load=False):
    """
    Setter method for signaling_address, mapped from YANG variable /networks/network/node/te/information_source_entry/signaling_address (inet:ip-address)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_signaling_address is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_signaling_address() directly.

    YANG Description: The node's signaling address.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="signaling-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:ip-address', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """signaling_address must be of a type compatible with inet:ip-address""",
          'defined-type': "inet:ip-address",
          'generated-type': """YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="signaling-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:ip-address', is_config=False)""",
        })

    self.__signaling_address = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_signaling_address(self):
    self.__signaling_address = YANGDynClass(unique=True, base=TypedListType(allowed_type=[RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(%[\\p{N}\\p{L}]+)?'}),RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '((:|[0-9a-fA-F]{0,4}):)([0-9a-fA-F]{0,4}:){0,5}((([0-9a-fA-F]{0,4}:)?(:|[0-9a-fA-F]{0,4}))|(((25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])\\.){3}(25[0-5]|2[0-4][0-9]|[01]?[0-9]?[0-9])))(%[\\p{N}\\p{L}]+)?'}),]), is_leaf=False, yang_name="signaling-address", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='inet:ip-address', is_config=False)


  def _get_underlay_topology(self):
    """
    Getter method for underlay_topology, mapped from YANG variable /networks/network/node/te/information_source_entry/underlay_topology (container)

    YANG Description: When an abstract node encapsulates a topology, the
attributes in this container point to said topology.
    """
    return self.__underlay_topology
      
  def _set_underlay_topology(self, v, load=False):
    """
    Setter method for underlay_topology, mapped from YANG variable /networks/network/node/te/information_source_entry/underlay_topology (container)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_underlay_topology is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_underlay_topology() directly.

    YANG Description: When an abstract node encapsulates a topology, the
attributes in this container point to said topology.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=underlay_topology.underlay_topology, is_container='container', yang_name="underlay-topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """underlay_topology must be of a type compatible with container""",
          'defined-type': "container",
          'generated-type': """YANGDynClass(base=underlay_topology.underlay_topology, is_container='container', yang_name="underlay-topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)""",
        })

    self.__underlay_topology = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_underlay_topology(self):
    self.__underlay_topology = YANGDynClass(base=underlay_topology.underlay_topology, is_container='container', yang_name="underlay-topology", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, extensions=None, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='container', is_config=False)

  information_source = __builtin__.property(_get_information_source)
  information_source_instance = __builtin__.property(_get_information_source_instance)
  information_source_state = __builtin__.property(_get_information_source_state)
  connectivity_matrices = __builtin__.property(_get_connectivity_matrices)
  domain_id = __builtin__.property(_get_domain_id)
  is_abstract = __builtin__.property(_get_is_abstract)
  name = __builtin__.property(_get_name)
  signaling_address = __builtin__.property(_get_signaling_address)
  underlay_topology = __builtin__.property(_get_underlay_topology)


  _pyangbind_elements = OrderedDict([('information_source', information_source), ('information_source_instance', information_source_instance), ('information_source_state', information_source_state), ('connectivity_matrices', connectivity_matrices), ('domain_id', domain_id), ('is_abstract', is_abstract), ('name', name), ('signaling_address', signaling_address), ('underlay_topology', underlay_topology), ])


