from copy import deepcopy
from service.proto.context_pb2 import ServiceStatusEnum, ServiceTypeEnum
from .CommonObjects import CONTEXT_ID
from service.service.service_handlers.Tools import config_rule_set, constraint, endpoint_id

# use "deepcopy" to prevent propagating forced changes during tests

SERVICE_L3NM_EMU_UUID = 'SVC_L3NM_EMU'
SERVICE_L3NM_EMU_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'service_uuid': {'uuid': SERVICE_L3NM_EMU_UUID}
}
SERVICE_L3NM_EMU = {
    'service_id': deepcopy(SERVICE_L3NM_EMU_ID),
    'service_type': ServiceTypeEnum.SERVICETYPE_L3NM,
    'service_endpoint_ids' : [],
    'service_constraints': [],
    'service_status': {'service_status': ServiceStatusEnum.SERVICESTATUS_PLANNED},
    'service_config': {'config_rules': []},
}

DEVICE1_UUID = 'EMU-1'
DEVICE1_ID = {'device_uuid': {'uuid': DEVICE1_UUID}}
DEVICE1_ENDPOINT_UUID = 'EP100'

DEVICE2_UUID = 'EMU-2'
DEVICE2_ID = {'device_uuid': {'uuid': DEVICE2_UUID}}
DEVICE2_ENDPOINT_UUID = 'EP100'

SERVICE_L3NM_EMU_ENDPOINT_IDS = [
    endpoint_id(DEVICE1_ID, DEVICE1_ENDPOINT_UUID),
    endpoint_id(DEVICE2_ID, DEVICE2_ENDPOINT_UUID),
]

SERVICE_L3NM_EMU_CONSTRAINTS = [
    constraint('latency_ms', 15.2),
    constraint('jitter_us', 1.2),
]

SERVICE_L3NM_EMU_CONFIG_RULES = [
    config_rule_set('settings', {
        'route_distinguisher': '60001:801', 'mtu': 1512, 'address_families': ['IPV4']
    }),
    config_rule_set('device[{:s}]/endpoint[{:s}]/settings'.format(DEVICE1_UUID, DEVICE1_ENDPOINT_UUID), {
        'router_id': '10.0.0.1', 'sub_interface_index': 1,
    }),
    config_rule_set('device[{:s}]/endpoint[{:s}]/settings'.format(DEVICE2_UUID, DEVICE2_ENDPOINT_UUID), {
        'router_id': '10.0.0.2', 'sub_interface_index': 1,
    }),
]
