import operator
from copy import deepcopy
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from service.proto.context_pb2 import DeviceDriverEnum, DeviceOperationalStatusEnum
from service.service.service_handlers.Tools import config_rule_set

# use "deepcopy" to prevent propagating forced changes during tests

CONTEXT_ID = {'context_uuid': {'uuid': DEFAULT_CONTEXT_UUID}}
CONTEXT = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_ids': [],
    'service_ids': [],
}

TOPOLOGY_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_uuid': {'uuid': DEFAULT_TOPOLOGY_UUID},
}
TOPOLOGY = {
    'topology_id': deepcopy(TOPOLOGY_ID),
    'device_ids': [],
    'link_ids': [],
}

DEVICE_EMU1_UUID = 'EMU-1'
DEVICE_EMU1_ID = {'device_uuid': {'uuid': DEVICE_EMU1_UUID}}
DEVICE_EMU1 = {
    'device_id': deepcopy(DEVICE_EMU1_ID),
    'device_type': 'emulated',
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_UNDEFINED],
    'device_endpoints': [],
}

DEVICE_EMU2_UUID = 'EMU-2'
DEVICE_EMU2_ID = {'device_uuid': {'uuid': DEVICE_EMU2_UUID}}
DEVICE_EMU2 = {
    'device_id': deepcopy(DEVICE_EMU2_ID),
    'device_type': 'emulated',
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_ENABLED,
    'device_drivers': [DeviceDriverEnum.DEVICEDRIVER_UNDEFINED],
    'device_endpoints': [],
}

DEVICE_EMU_ENDPOINTS = []
for endpoint_uuid in ['EP1', 'EP2', 'EP3', 'EP100']:
    DEVICE_EMU_ENDPOINTS.append((endpoint_uuid, '10Gbps', []))

DEVICE_EMU_CONNECT_RULES = [
    config_rule_set('_connect/address', '127.0.0.1'),
    config_rule_set('_connect/port',    '0'),
    config_rule_set('_connect/settings', {'endpoints': [
        {
            'uuid': endpoint_uuid, 'type': endpoint_type,
            'sample_types': list(map(operator.attrgetter('value'), endpoint_sample_types)),
        }
        for endpoint_uuid,endpoint_type,endpoint_sample_types in DEVICE_EMU_ENDPOINTS
    ]}),
]
