from common.proto.context_pb2 import (
   Topology,TopologyList ,TopologyId,Empty,
   Service, ServiceId , ServiceList
)
from google.protobuf.json_format import MessageToDict
from google.protobuf.json_format import ParseDict

import copy

def process_services (services:ServiceList) : 

  
   service_add = {}
   service = {}
   services_result = []
   
   
   dict_services= MessageToDict(services)
   services_list=dict_services.get('services',[])
   for s in services_list:
       
      service_copy = copy.deepcopy(s)
      service_copy['service_endpoint_ids'] = []
      service_copy['service_constraints'] = []
      service_copy['service_config'] = {'config_rules': []}
      service_add = ParseDict(service_copy,Service())
      service = ParseDict(s,Service())
   
      services_result.append((service_add , service))
   return services_result   