# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class source(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/link/source. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: This container holds the logical source of a particular
link.
  """
  __slots__ = ('_path_helper', '_extmethods', '__source_node','__source_tp',)

  _yang_name = 'source'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__source_node = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)
    self.__source_tp = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'link', 'source']

  def _get_source_node(self):
    """
    Getter method for source_node, mapped from YANG variable /networks/network/link/source/source_node (leafref)

    YANG Description: Source node identifier.  Must be in the same topology.
    """
    return self.__source_node
      
  def _set_source_node(self, v, load=False):
    """
    Setter method for source_node, mapped from YANG variable /networks/network/link/source/source_node (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_node is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_node() directly.

    YANG Description: Source node identifier.  Must be in the same topology.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_node must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)""",
        })

    self.__source_node = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_node(self):
    self.__source_node = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-node", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)


  def _get_source_tp(self):
    """
    Getter method for source_tp, mapped from YANG variable /networks/network/link/source/source_tp (leafref)

    YANG Description: This termination point is located within the source node
and terminates the link.
    """
    return self.__source_tp
      
  def _set_source_tp(self, v, load=False):
    """
    Setter method for source_tp, mapped from YANG variable /networks/network/link/source/source_tp (leafref)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_source_tp is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_source_tp() directly.

    YANG Description: This termination point is located within the source node
and terminates the link.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=six.text_type, is_leaf=True, yang_name="source-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """source_tp must be of a type compatible with leafref""",
          'defined-type': "leafref",
          'generated-type': """YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)""",
        })

    self.__source_tp = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_source_tp(self):
    self.__source_tp = YANGDynClass(base=six.text_type, is_leaf=True, yang_name="source-tp", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-network-topology', defining_module='ietf-network-topology', yang_type='leafref', is_config=True)

  source_node = __builtin__.property(_get_source_node, _set_source_node)
  source_tp = __builtin__.property(_get_source_tp, _set_source_tp)


  _pyangbind_elements = OrderedDict([('source_node', source_node), ('source_tp', source_tp), ])


