# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class node(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/statistics/node. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Contains statistics attributes at the TE node level.
  """
  __slots__ = ('_path_helper', '_extmethods', '__disables','__enables','__maintenance_sets','__maintenance_clears','__modifies',)

  _yang_name = 'node'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__disables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__enables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__maintenance_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__maintenance_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    self.__modifies = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'statistics', 'node']

  def _get_disables(self):
    """
    Getter method for disables, mapped from YANG variable /networks/network/node/te/statistics/node/disables (yang:counter32)

    YANG Description: Number of times that a node was disabled.
    """
    return self.__disables
      
  def _set_disables(self, v, load=False):
    """
    Setter method for disables, mapped from YANG variable /networks/network/node/te/statistics/node/disables (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_disables is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_disables() directly.

    YANG Description: Number of times that a node was disabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """disables must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__disables = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_disables(self):
    self.__disables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="disables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_enables(self):
    """
    Getter method for enables, mapped from YANG variable /networks/network/node/te/statistics/node/enables (yang:counter32)

    YANG Description: Number of times that a node was enabled.
    """
    return self.__enables
      
  def _set_enables(self, v, load=False):
    """
    Setter method for enables, mapped from YANG variable /networks/network/node/te/statistics/node/enables (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_enables is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_enables() directly.

    YANG Description: Number of times that a node was enabled.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """enables must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__enables = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_enables(self):
    self.__enables = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="enables", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_maintenance_sets(self):
    """
    Getter method for maintenance_sets, mapped from YANG variable /networks/network/node/te/statistics/node/maintenance_sets (yang:counter32)

    YANG Description: Number of times that a node was put in maintenance.
    """
    return self.__maintenance_sets
      
  def _set_maintenance_sets(self, v, load=False):
    """
    Setter method for maintenance_sets, mapped from YANG variable /networks/network/node/te/statistics/node/maintenance_sets (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maintenance_sets is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maintenance_sets() directly.

    YANG Description: Number of times that a node was put in maintenance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maintenance_sets must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__maintenance_sets = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maintenance_sets(self):
    self.__maintenance_sets = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-sets", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_maintenance_clears(self):
    """
    Getter method for maintenance_clears, mapped from YANG variable /networks/network/node/te/statistics/node/maintenance_clears (yang:counter32)

    YANG Description: Number of times that a node was taken out of
maintenance.
    """
    return self.__maintenance_clears
      
  def _set_maintenance_clears(self, v, load=False):
    """
    Setter method for maintenance_clears, mapped from YANG variable /networks/network/node/te/statistics/node/maintenance_clears (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_maintenance_clears is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_maintenance_clears() directly.

    YANG Description: Number of times that a node was taken out of
maintenance.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """maintenance_clears must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__maintenance_clears = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_maintenance_clears(self):
    self.__maintenance_clears = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="maintenance-clears", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)


  def _get_modifies(self):
    """
    Getter method for modifies, mapped from YANG variable /networks/network/node/te/statistics/node/modifies (yang:counter32)

    YANG Description: Number of times that a node was modified.
    """
    return self.__modifies
      
  def _set_modifies(self, v, load=False):
    """
    Setter method for modifies, mapped from YANG variable /networks/network/node/te/statistics/node/modifies (yang:counter32)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_modifies is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_modifies() directly.

    YANG Description: Number of times that a node was modified.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """modifies must be of a type compatible with yang:counter32""",
          'defined-type': "yang:counter32",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)""",
        })

    self.__modifies = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_modifies(self):
    self.__modifies = YANGDynClass(base=RestrictedClassType(base_type=long, restriction_dict={'range': ['0..4294967295']}, int_size=32), is_leaf=True, yang_name="modifies", parent=self, path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='yang:counter32', is_config=False)

  disables = __builtin__.property(_get_disables)
  enables = __builtin__.property(_get_enables)
  maintenance_sets = __builtin__.property(_get_maintenance_sets)
  maintenance_clears = __builtin__.property(_get_maintenance_clears)
  modifies = __builtin__.property(_get_modifies)


  _pyangbind_elements = OrderedDict([('disables', disables), ('enables', enables), ('maintenance_sets', maintenance_sets), ('maintenance_clears', maintenance_clears), ('modifies', modifies), ])


