/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseActiveLine
extends AbstractComponent {
    private final HtmlColor foregroundColor;
    private final HtmlColor lifeLineBackground;
    private final boolean closeUp;
    private final boolean closeDown;
    private final boolean withShadow;

    public ComponentRoseActiveLine(HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, boolean bl2, boolean bl3) {
        this.foregroundColor = htmlColor;
        this.lifeLineBackground = htmlColor2;
        this.closeUp = bl;
        this.closeDown = bl2;
        this.withShadow = bl3;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        Dimension2D dimension2D = area.getDimensionToUse();
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)(dimension2D.getWidth() - this.getPreferredWidth(stringBounder)) / 2;
        URectangle uRectangle = new URectangle(this.getPreferredWidth(stringBounder), dimension2D.getHeight());
        if (this.withShadow) {
            uRectangle.setDeltaShadow(1.0);
        }
        uGraphic = uGraphic.apply(new UChangeColor(this.foregroundColor));
        if (this.closeUp && this.closeDown) {
            uGraphic.apply(new UChangeBackColor(this.lifeLineBackground)).apply(new UTranslate(n, 0.0)).draw(uRectangle);
            return;
        }
        uGraphic.apply(new UChangeBackColor(this.lifeLineBackground)).apply(new UChangeColor(this.lifeLineBackground)).apply(new UTranslate(n, 0.0)).draw(uRectangle);
        ULine uLine = new ULine(0.0, dimension2D.getHeight());
        uGraphic.apply(new UTranslate(n, 0.0)).draw(uLine);
        uGraphic.apply(new UTranslate((double)n + this.getPreferredWidth(stringBounder), 0.0)).draw(uLine);
        ULine uLine2 = new ULine(this.getPreferredWidth(stringBounder), 0.0);
        if (this.closeUp) {
            uGraphic.apply(new UTranslate(n, 0.0)).draw(uLine2);
        }
        if (this.closeDown) {
            uGraphic.apply(new UTranslate(n, dimension2D.getHeight())).draw(uLine2);
        }
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return 0.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return 10.0;
    }
}

