from typing import Dict
from ...engines._DatabaseEngine import _DatabaseEngine
from ..entity._Entity import _Entity
from ..entity.EntityAttributes import EntityAttributes
from ..entity.EntityCollection import EntityCollection
from .Keys import KEY_CONTEXT, KEY_TOPOLOGIES
from .Topology import Topology

VALIDATORS = {}

class Context(_Entity):
    def __init__(self, context_uuid : str, database_engine : _DatabaseEngine):
        self._database_engine = database_engine
        super().__init__(context_uuid, parent=self)
        self._attributes = EntityAttributes(self, KEY_CONTEXT, validators=VALIDATORS)
        self._topologies = EntityCollection(self, KEY_TOPOLOGIES)

    @property
    def database_engine(self) -> _DatabaseEngine: return self._database_engine

    @property
    def parent(self) -> 'Context': return self

    @property
    def context(self) -> 'Context': return self

    @property
    def context_uuid(self) -> str: return self._entity_uuid

    @property
    def attributes(self) -> EntityAttributes: return self._attributes

    @property
    def topologies(self) -> EntityCollection: return self._topologies

    def topology(self, topology_uuid : str) -> Topology: return Topology(topology_uuid, self)

    def create(self) -> 'Context': return self

    def delete(self):
        for topology_uuid in self.topologies.get(): self.topology(topology_uuid).delete()
        self.attributes.delete()

    def dump_id(self) -> Dict:
        return {
            'contextUuid': {'uuid': self.context_uuid},
        }

    def dump(self) -> Dict:
        return {topology_uuid : self.topology(topology_uuid).dump() for topology_uuid in self.topologies.get()}
