# -*- coding: utf-8 -*-
from operator import attrgetter
from pyangbind.lib.yangtypes import RestrictedPrecisionDecimalType
from pyangbind.lib.yangtypes import RestrictedClassType
from pyangbind.lib.yangtypes import TypedListType
from pyangbind.lib.yangtypes import YANGBool
from pyangbind.lib.yangtypes import YANGListType
from pyangbind.lib.yangtypes import YANGDynClass
from pyangbind.lib.yangtypes import ReferenceType
from pyangbind.lib.yangtypes import YANGBinary
from pyangbind.lib.yangtypes import YANGBitsType
from pyangbind.lib.base import PybindBase
from collections import OrderedDict
from decimal import Decimal
import six

# PY3 support of some PY2 keywords (needs improved)
if six.PY3:
  import builtins as __builtin__
  long = int
elif six.PY2:
  import __builtin__

class numbered_node_hop(PybindBase):
  """
  This class was auto-generated by the PythonClass plugin for PYANG
  from YANG module ietf-network - based on the path /networks/network/node/te/tunnel-termination-point/local-link-connectivities/underlay/primary-path/path-element/numbered-node-hop. Each member element of
  the container is represented as a class variable - with a specific
  YANG type.

  YANG Description: Numbered node route hop.
  """
  __slots__ = ('_path_helper', '_extmethods', '__node_id','__hop_type',)

  _yang_name = 'numbered-node-hop'
  _yang_namespace = 'urn:ietf:params:xml:ns:yang:ietf-network'

  _pybind_generated_by = 'container'

  def __init__(self, *args, **kwargs):

    self._path_helper = False

    self._extmethods = False
    self.__node_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="node-id", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-node-id', is_config=True)
    self.__hop_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)

    load = kwargs.pop("load", None)
    if args:
      if len(args) > 1:
        raise TypeError("cannot create a YANG container with >1 argument")
      all_attr = True
      for e in self._pyangbind_elements:
        if not hasattr(args[0], e):
          all_attr = False
          break
      if not all_attr:
        raise ValueError("Supplied object did not have the correct attributes")
      for e in self._pyangbind_elements:
        nobj = getattr(args[0], e)
        if nobj._changed() is False:
          continue
        setmethod = getattr(self, "_set_%s" % e)
        if load is None:
          setmethod(getattr(args[0], e))
        else:
          setmethod(getattr(args[0], e), load=load)

  def _path(self):
    if hasattr(self, "_parent"):
      return self._parent._path()+[self._yang_name]
    else:
      return ['networks', 'network', 'node', 'te', 'tunnel-termination-point', 'local-link-connectivities', 'underlay', 'primary-path', 'path-element', 'numbered-node-hop']

  def _get_node_id(self):
    """
    Getter method for node_id, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/underlay/primary_path/path_element/numbered_node_hop/node_id (te-node-id)

    YANG Description: The identifier of a node in the TE topology.
    """
    return self.__node_id
      
  def _set_node_id(self, v, load=False):
    """
    Setter method for node_id, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/underlay/primary_path/path_element/numbered_node_hop/node_id (te-node-id)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_node_id is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_node_id() directly.

    YANG Description: The identifier of a node in the TE topology.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="node-id", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-node-id', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """node_id must be of a type compatible with te-node-id""",
          'defined-type': "ietf-te-topology:te-node-id",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="node-id", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-node-id', is_config=True)""",
        })

    self.__node_id = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_node_id(self):
    self.__node_id = YANGDynClass(base=RestrictedClassType(base_type=six.text_type, restriction_dict={'pattern': '(([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])\\.){3}([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])'}), is_leaf=True, yang_name="node-id", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-node-id', is_config=True)


  def _get_hop_type(self):
    """
    Getter method for hop_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/underlay/primary_path/path_element/numbered_node_hop/hop_type (te-hop-type)

    YANG Description: Strict or loose hop.
    """
    return self.__hop_type
      
  def _set_hop_type(self, v, load=False):
    """
    Setter method for hop_type, mapped from YANG variable /networks/network/node/te/tunnel_termination_point/local_link_connectivities/underlay/primary_path/path_element/numbered_node_hop/hop_type (te-hop-type)
    If this variable is read-only (config: false) in the
    source YANG file, then _set_hop_type is considered as a private
    method. Backends looking to populate this variable should
    do so via calling thisObj._set_hop_type() directly.

    YANG Description: Strict or loose hop.
    """
    if hasattr(v, "_utype"):
      v = v._utype(v)
    try:
      t = YANGDynClass(v,base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)
    except (TypeError, ValueError):
      raise ValueError({
          'error-string': """hop_type must be of a type compatible with te-hop-type""",
          'defined-type': "ietf-te-topology:te-hop-type",
          'generated-type': """YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)""",
        })

    self.__hop_type = t
    if hasattr(self, '_set'):
      self._set()

  def _unset_hop_type(self):
    self.__hop_type = YANGDynClass(base=RestrictedClassType(base_type=six.text_type,                                     restriction_type="dict_key",                                     restriction_arg={'loose': {}, 'strict': {}},), default=six.text_type("strict"), is_leaf=True, yang_name="hop-type", parent=self, choice=('type', 'numbered-node-hop'), path_helper=self._path_helper, extmethods=self._extmethods, register_paths=True, namespace='urn:ietf:params:xml:ns:yang:ietf-te-topology', defining_module='ietf-te-topology', yang_type='te-hop-type', is_config=True)

  node_id = __builtin__.property(_get_node_id, _set_node_id)
  hop_type = __builtin__.property(_get_hop_type, _set_hop_type)

  __choices__ = {'type': {'numbered-node-hop': ['node_id', 'hop_type']}}
  _pyangbind_elements = OrderedDict([('node_id', node_id), ('hop_type', hop_type), ])


