# 2.1. Configure Python Environment

This section describes how to configure the Python environment to run experiments and develop code for the ETSI
TeraFlowSDN controller.
In particular, we use [PyEnv](https://github.com/pyenv/pyenv) to install the appropriate version of Python and manage
the virtual environments.


## 2.1.1. Upgrade the Ubuntu distribution
Skip this step if you already did it during the creation of the VM.
```bash
sudo apt-get update -y
sudo apt-get dist-upgrade -y
```


## 2.1.2. Install PyEnv dependencies in the VM
```bash
sudo apt-get install -y make build-essential libssl-dev zlib1g-dev libbz2-dev libreadline-dev libsqlite3-dev wget \
    curl llvm git libncursesw5-dev xz-utils tk-dev libxml2-dev libxmlsec1-dev libffi-dev liblzma-dev
```


## 2.1.3. Install PyEnv
```bash
curl https://pyenv.run | bash
# When finished, edit ~/.bash_profile // ~/.profile // ~/.bashrc as the installer proposes.
# In general, it means to append the following lines to ~/.bashrc:
export PYENV_ROOT="$HOME/.pyenv"
command -v pyenv >/dev/null || export PATH="$PYENV_ROOT/bin:$PATH"
eval "$(pyenv init -)"
eval "$(pyenv virtualenv-init -)"
```

In case .bashrc is not linked properly to your profile, you may need to append the following line into your local .profile file:

```bash
# Open ~/.profile and append this line:
+source "$HOME"/.bashrc
```


## 2.1.4. Restart the VM
Restart the VM for all the changes to take effect.
```bash
sudo reboot
```


## 2.1.5. Install Python 3.9 over PyEnv
```bash
pyenv install 3.9.13
    # This command might take some minutes depending on your Internet connection speed and the performance of your VM.
```


## 2.1.6. Create the Virtual Environment for TeraFlowSDN
The following commands create a virtual environment named as `tfs` using Python v3.9.13 and associate that environment
with the current folder, i.e., `~/tfs-ctrl`. That way, when you are in that folder, the associated virtual environment
will be used, thus inheriting the Python interpreter, i.e., Python v3.9.13, and the Python packages installed on it.

```bash
cd ~/tfs-ctrl
pyenv virtualenv 3.9.13 tfs
pyenv local 3.9.13/envs/tfs
```

In case that the correct pyenv does not get automatically activated when you change to the tfs-ctrl/ folder, then execute the following command:

```bash
cd ~/tfs-ctrl
pyenv activate 3.9.13/envs/tfs
```

After completing these commands, you should see in your prompt that now you're within the virtual environment
`3.9.13/envs/tfs` on folder `~/tfs-ctrl`:
```
(3.9.13/envs/tfs) tfs@tfs-vm:~/tfs-ctrl$
```


## 2.1.7. Install the basic Python packages within the virtual environment
From within the `3.9.13/envs/tfs` environment on folder `~/tfs-ctrl`, run the following commands to install the basic
Python packages required to work with TeraFlowSDN.
```bash
cd ~/tfs-ctrl
./install_requirements.sh
```
