from copy import deepcopy
from common.Constants import DEFAULT_CONTEXT_UUID, DEFAULT_TOPOLOGY_UUID
from context.proto.context_pb2 import ConfigActionEnum, DeviceDriverEnum, DeviceOperationalStatusEnum
from .Tools import config_rule

DEVICE_EMU_UUID     = 'EMULARED'
DEVICE_EMU_TYPE     = 'emulated'
DEVICE_EMU_ADDRESS  = '127.0.0.1'
DEVICE_EMU_PORT     = '0'
DEVICE_EMU_DRIVERS  = [DeviceDriverEnum.DEVICEDRIVER_UNDEFINED]

try:
    from ._device_credentials import (
        DEVICE_INF_UUID, DEVICE_INF_TYPE, DEVICE_INF_ADDRESS, DEVICE_INF_PORT, DEVICE_INF_USERNAME,
        DEVICE_INF_PASSWORD, DEVICE_INF_DRIVERS, DEVICE_INF_CONFIG_RULES)
except ImportError:
    DEVICE_INF_UUID     = 'DEV2'
    DEVICE_INF_TYPE     = 'packet-router'
    DEVICE_INF_ADDRESS  = '127.0.0.1'
    DEVICE_INF_PORT     = '830'
    DEVICE_INF_USERNAME = 'username'
    DEVICE_INF_PASSWORD = 'password'
    DEVICE_INF_DRIVERS  = [DeviceDriverEnum.DEVICEDRIVER_OPENCONFIG]
    DEVICE_INF_CONFIG_RULES = []

## use "deepcopy" to prevent propagating forced changes during tests
CONTEXT_ID = {'context_uuid': {'uuid': DEFAULT_CONTEXT_UUID}}
CONTEXT = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_ids': [],
    'service_ids': [],
}

TOPOLOGY_ID = {
    'context_id': deepcopy(CONTEXT_ID),
    'topology_uuid': {'uuid': DEFAULT_TOPOLOGY_UUID},
}
TOPOLOGY = {
    'topology_id': deepcopy(TOPOLOGY_ID),
    'device_ids': [],
    'link_ids': [],
}

DEVICE_EMU_ID = {'device_uuid': {'uuid': DEVICE_EMU_UUID}}
DEVICE_EMU = {
    'device_id': deepcopy(DEVICE_EMU_ID),
    'device_type': DEVICE_EMU_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_EMU_DRIVERS,
    'device_endpoints': [],
}

DEVICE_EMU_CONNECT_RULES = [
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/address',  DEVICE_EMU_ADDRESS ),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/port',     DEVICE_EMU_PORT    ),
]

DEVICE_EMU_CONFIG_RULES = [
    config_rule(ConfigActionEnum.CONFIGACTION_SET, 'dev/rsrc1/value', 'value1'),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, 'dev/rsrc2/value', 'value2'),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, 'dev/rsrc3/value', 'value3'),
]


DEVICE_INF_ID = {'device_uuid': {'uuid': DEVICE_INF_UUID}}
DEVICE_INF = {
    'device_id': deepcopy(DEVICE_INF_ID),
    'device_type': DEVICE_INF_TYPE,
    'device_config': {'config_rules': []},
    'device_operational_status': DeviceOperationalStatusEnum.DEVICEOPERATIONALSTATUS_DISABLED,
    'device_drivers': DEVICE_INF_DRIVERS,
    'device_endpoints': [],
}

DEVICE_INF_CONNECT_RULES = [
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/address',  DEVICE_INF_ADDRESS ),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/port',     DEVICE_INF_PORT    ),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/username', DEVICE_INF_USERNAME),
    config_rule(ConfigActionEnum.CONFIGACTION_SET, '_connect/password', DEVICE_INF_PASSWORD),
]
