from copy import deepcopy

def config_rule(action, resource_key, resource_value):
    return {'action': action, 'resource_key': resource_key, 'resource_value': resource_value}

def endpoint_id(topology_id, device_id, endpoint_uuid):
    return {'topology_id': deepcopy(topology_id), 'device_id': deepcopy(device_id),
            'endpoint_uuid': {'uuid': endpoint_uuid}}

def endpoint(topology_id, device_id, endpoint_uuid, endpoint_type):
    return {'endpoint_id': endpoint_id(topology_id, device_id, endpoint_uuid), 'endpoint_type': endpoint_type}
